export default `input[type=search][tuiSearch]{transition-property:background;transition-duration:var(--tui-duration, .3s);transition-timing-function:ease-in-out;block-size:2.25rem;box-sizing:border-box;outline:none;border:none;border-radius:.625rem;padding:0 0 0 1.875rem;font:1.0625rem SF Pro Text,sans-serif;color:var(--tui-text-primary);caret-color:var(--tui-text-action);background:var(--tui-background-neutral-2) url(data:image/svg+xml;charset=UTF-8,%3Csvg%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20fill%3D%22none%22%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%3E%3Cpath%20d%3D%22M4%2010.4714C4%206.90319%206.93142%204%2010.5343%204C14.1372%204%2017.0686%206.90319%2017.0686%2010.4714C17.0686%2011.9473%2016.5691%2013.3016%2015.7257%2014.3882L19.7298%2018.3781C19.9017%2018.5484%2020%2018.7836%2020%2019.0431C20%2019.5864%2019.6151%2020%2019.0583%2020C18.7963%2020%2018.5507%2019.9108%2018.3623%2019.7243L14.3337%2015.7263C13.261%2016.4886%2011.9591%2016.9427%2010.5343%2016.9427C6.93142%2016.9427%204%2014.0395%204%2010.4714ZM5.4002%2010.4714C5.4002%2013.2772%207.70113%2015.556%2010.5343%2015.556C13.3675%2015.556%2015.6684%2013.2772%2015.6684%2010.4714C15.6684%207.66548%2013.3675%205.38672%2010.5343%205.38672C7.70113%205.38672%205.4002%207.66548%205.4002%2010.4714Z%22%20fill%3D%22%239299A2%22%2F%3E%3C%2Fsvg%3E) no-repeat .25rem center}input[type=search][tuiSearch]::placeholder{color:var(--tui-text-secondary)}input[type=search][tuiSearch]:active{background-color:var(--tui-background-neutral-2-pressed)}input[type=search][tuiSearch]::-webkit-search-cancel-button{transition-property:background;transition-duration:var(--tui-duration, .3s);transition-timing-function:ease-in-out;display:block;appearance:none;block-size:2.25rem;inline-size:2rem;box-sizing:border-box;border:.5rem solid transparent;margin:0;background:var(--tui-text-secondary);opacity:1;mask:url(data:image/svg+xml;charset=UTF-8,%3Csvg%20width%3D%2216%22%20height%3D%2216%22%20viewBox%3D%220%200%2016%2016%22%20fill%3D%22none%22%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%3E%3Cpath%20d%3D%22M8%2016C3.63137%2016%200%2012.3686%200%208C0%203.62353%203.62353%200%207.99216%200C12.3686%200%2016%203.62353%2016%208C16%2012.3686%2012.3765%2016%208%2016ZM5.36471%2011.2941C5.5451%2011.2941%205.7098%2011.2314%205.83529%2011.1059L8%208.92549L10.1725%2011.1059C10.2902%2011.2314%2010.4549%2011.2941%2010.6353%2011.2941C11.0039%2011.2941%2011.2941%2011.0039%2011.2941%2010.6431C11.2941%2010.4627%2011.2314%2010.298%2011.098%2010.1804L8.92549%208.00784L11.1059%205.82745C11.2471%205.68627%2011.302%205.5451%2011.302%205.36471C11.302%205.00392%2011.0118%204.72157%2010.651%204.72157C10.4784%204.72157%2010.3373%204.77647%2010.2039%204.9098L8%207.09804L5.81176%204.91765C5.68627%204.8%205.5451%204.73726%205.36471%204.73726C5.00392%204.73726%204.72157%205.01177%204.72157%205.38039C4.72157%205.55294%204.78431%205.7098%204.9098%205.83529L7.08235%208.00784L4.9098%2010.1882C4.78431%2010.3059%204.72157%2010.4706%204.72157%2010.6431C4.72157%2011.0039%205.00392%2011.2941%205.36471%2011.2941Z%22%20fill%3D%22black%22%2F%3E%3C%2Fsvg%3E) no-repeat center}input[type=search][tuiSearch]::-webkit-search-cancel-button:active{background:var(--tui-text-secondary-pressed)}[data-platform=android] tui-app-bar{font:var(--tui-font-heading-6);block-size:3.5rem}[data-platform=android] tui-app-bar>.t-content{position:static;padding:0 0 0 1rem;text-align:start;transform:none;max-inline-size:calc(100% - var(--t-sides, 0px) / 2)}[data-platform=android] tui-app-bar>.t-content>*{max-inline-size:calc(100% - var(--t-sides, 0px))}[data-platform=android] tui-app-bar>:last-child [tuiIconButton]{margin:0 -.25rem}[data-platform=android] input[tuiCheckbox]{--t-size: 1.375rem;color:var(--tui-text-primary-on-accent-2)!important;border-radius:100%;outline:.125rem solid var(--tui-background-neutral-2);outline-offset:-.125rem;transition:none;box-shadow:none!important;background:var(--t-background)!important}[data-platform=android] input[tuiCheckbox]:checked,[data-platform=android] input[tuiCheckbox]:indeterminate{--t-background: var(--tui-background-accent-2);outline:none}[data-platform=android] input[tuiCheckbox]:checked:invalid,[data-platform=android] input[tuiCheckbox]:indeterminate:invalid{--t-background: var(--tui-status-negative)}[data-platform=android] input[tuiCheckbox]:checked:disabled:not(._readonly),[data-platform=android] input[tuiCheckbox]:indeterminate:disabled:not(._readonly){--t-background: var(--tui-background-neutral-2)}[data-platform=android] input[tuiCheckbox]:checked:before,[data-platform=android] input[tuiCheckbox]:indeterminate:before{clip-path:inset(0);transition-delay:0s}[data-platform=android] input[tuiCheckbox]:before{mask-image:url('data:image/svg+xml,<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M6 13L1 8.19231L2.4 6.84615L6 10.3077L13.6 3L15 4.34615L6 13Z" fill="black"/></svg>');transition:clip-path var(--tui-duration) ease-in-out,mask 0s var(--tui-duration) ease-in-out;clip-path:inset(0 100% 0 0)}[data-platform=android] input[tuiCheckbox]:indeterminate:before{mask-image:url('data:image/svg+xml,<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><rect x="2" y="7" width="12" height="2" fill="black" /></svg>')}[data-platform=android] input[tuiCheckbox]:invalid{outline-color:var(--tui-status-negative-pale-hover)}[data-platform=android] input[tuiCheckbox][data-size=s]:before{inline-size:1rem;block-size:1rem}[data-platform=android] input[tuiRadio]{--t-size: 1.125rem;transition-property:color;transition-duration:var(--tui-duration, .3s);transition-timing-function:ease-in-out;color:var(--tui-background-neutral-2);outline:.125rem solid;outline-offset:-.125rem;box-shadow:none!important;background:transparent!important}[data-platform=android] input[tuiRadio]:disabled:not(._readonly){color:var(--tui-background-neutral-2)}[data-platform=android] input[tuiRadio]:checked{color:var(--tui-background-accent-2)}[data-platform=android] input[tuiRadio]:checked:after{transform:scale(.555)}[data-platform=android] input[tuiRadio]:invalid{color:var(--tui-status-negative-pale-hover)}[data-platform=android] input[tuiRadio]:invalid:checked{color:var(--tui-status-negative)}[data-platform=android] input[tuiSwitch]{transition-property:color,opacity;transition-duration:var(--tui-duration, .3s);transition-timing-function:ease-in-out;block-size:1.25rem;inline-size:2.5rem;color:var(--tui-border-hover)!important;background:transparent!important;overflow:visible}[data-platform=android] input[tuiSwitch]:before{content:"";display:block;block-size:100%;inline-size:100%;border:.1875rem solid transparent;box-sizing:border-box;border-radius:2rem;background:currentColor;background-clip:content-box;opacity:.5;transform:none;mask:none}[data-platform=android] input[tuiSwitch]:after{transition-property:transform;transition-duration:var(--tui-duration, .3s);transition-timing-function:ease-in-out;content:"";position:absolute;top:0;left:0;inline-size:1.25rem;block-size:1.25rem;border-radius:100%;background:#f6f6f6;transform:none;outline:none;box-shadow:0 .0625rem .0625rem #0000003d,0 0 .0625rem #0000001f,inset 0 .0625rem #ffffff1f!important}[data-platform=android] input[tuiSwitch]:checked{color:var(--tui-background-accent-2)!important;background:transparent}[data-platform=android] input[tuiSwitch]:checked:after{background:currentColor;transform:translate(1.25rem)}[data-platform=android] input[tuiSwitch]:invalid{color:var(--tui-status-negative)!important}[data-platform=android] input[tuiSwitch]:invalid:not(:checked){background:transparent;opacity:.4}[data-platform=android] input[tuiSwitch]:invalid:after{background:var(--tui-status-negative)}[data-platform=android] tui-badge-notification[data-size=l]{--t-size: 1.375rem}[data-platform=ios] tui-app-bar{block-size:2.75rem}[data-platform=ios] input[tuiCheckbox],[data-platform=ios] input[tuiRadio]{--t-size: 1.375rem;border-radius:100%;color:var(--tui-text-primary-on-accent-2)!important;outline:1px solid var(--tui-background-neutral-2);outline-offset:-1px;transition:none;box-shadow:none!important;background:var(--t-background)!important}[data-platform=ios] input[tuiCheckbox]:checked,[data-platform=ios] input[tuiRadio]:checked,[data-platform=ios] input[tuiCheckbox]:not([tuiRadio]):indeterminate,[data-platform=ios] input[tuiRadio]:not([tuiRadio]):indeterminate{--t-background: var(--tui-background-accent-2);outline:none}[data-platform=ios] input[tuiCheckbox]:checked:disabled:not(._readonly),[data-platform=ios] input[tuiRadio]:checked:disabled:not(._readonly),[data-platform=ios] input[tuiCheckbox]:not([tuiRadio]):indeterminate:disabled:not(._readonly),[data-platform=ios] input[tuiRadio]:not([tuiRadio]):indeterminate:disabled:not(._readonly){--t-background: var(--tui-background-neutral-2)}[data-platform=ios] input[tuiCheckbox]:checked:before,[data-platform=ios] input[tuiRadio]:checked:before,[data-platform=ios] input[tuiCheckbox]:not([tuiRadio]):indeterminate:before,[data-platform=ios] input[tuiRadio]:not([tuiRadio]):indeterminate:before{display:block;transform:none;mask:var(--t-icon) center / 100%}[data-platform=ios] input[tuiCheckbox]:checked:invalid,[data-platform=ios] input[tuiRadio]:checked:invalid,[data-platform=ios] input[tuiCheckbox]:not([tuiRadio]):indeterminate:invalid,[data-platform=ios] input[tuiRadio]:not([tuiRadio]):indeterminate:invalid{--t-background: var(--tui-status-negative)}[data-platform=ios] input[tuiCheckbox]:before,[data-platform=ios] input[tuiRadio]:before{--t-icon: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" fill="none" preserveAspectRatio="xMidYMid meet" height="100%" width="100%"><path d="M12.3368 4.33683C12.7859 3.88772 13.5141 3.88772 13.9632 4.33683C14.4123 4.78593 14.4123 5.51407 13.9632 5.96317L6.96317 12.9632C6.51407 13.4123 5.78593 13.4123 5.33683 12.9632L2.33683 9.96317C1.88772 9.51407 1.88772 8.78593 2.33683 8.33683C2.78593 7.88772 3.51407 7.88772 3.96317 8.33683L6.15 10.5237L12.3368 4.33683Z" fill="black"/></svg>');display:none}[data-platform=ios] input[tuiCheckbox]:not([tuiRadio]):indeterminate:before,[data-platform=ios] input[tuiRadio]:not([tuiRadio]):indeterminate:before{--t-icon: url('data:image/svg+xml,<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><rect x="2" y="7" width="12" height="2.3" rx="1.15" fill="black" /></svg>')}[data-platform=ios] input[tuiCheckbox]:invalid,[data-platform=ios] input[tuiRadio]:invalid{outline-color:var(--tui-status-negative-pale-hover)}[data-platform=ios] input[tuiCheckbox][data-size=s]:before,[data-platform=ios] input[tuiRadio][data-size=s]:before{inline-size:1rem;block-size:1rem}[data-platform=ios] input[tuiSwitch]{block-size:1.9375rem;inline-size:3.1875rem;border-radius:2rem;color:#fff;background:var(--tui-background-neutral-2);overflow:visible}[data-platform=ios] input[tuiSwitch]:before{opacity:0}[data-platform=ios] input[tuiSwitch]:after{transition-property:transform,width;transition-duration:var(--tui-duration, .3s);transition-timing-function:ease-in-out;right:auto;inline-size:1.9375rem;block-size:1.9375rem;border-radius:2rem;background:currentColor;transform:scale(.871);outline:none;box-shadow:0 .25rem .125rem #0000000f,0 .25rem .5rem #00000026!important}[data-platform=ios] input[tuiSwitch]:active:after{inline-size:2.3rem}[data-platform=ios] input[tuiSwitch]:checked,[data-platform=ios] input[tuiSwitch]:checked:hover,[data-platform=ios] input[tuiSwitch]:checked:active{background:var(--tui-background-accent-2)}[data-platform=ios] input[tuiSwitch]:checked:invalid,[data-platform=ios] input[tuiSwitch]:checked:hover:invalid,[data-platform=ios] input[tuiSwitch]:checked:active:invalid{background:var(--tui-status-negative)}[data-platform=ios] input[tuiSwitch]:checked:after,[data-platform=ios] input[tuiSwitch]:checked:hover:after,[data-platform=ios] input[tuiSwitch]:checked:active:after{transform:scale(.871) translate(1.44rem)}[data-platform=ios] input[tuiSwitch]:checked:active:after,[data-platform=ios] input[tuiSwitch]:checked:hover:active:after,[data-platform=ios] input[tuiSwitch]:checked:active:active:after{transform:scale(.871) translate(1.0775rem)}[data-platform=ios] tui-segmented>*:not(tui-segmented_active):active{background-color:var(--tui-background-neutral-1)}[data-platform=ios] tui-segmented>.tui-segmented_active:active{opacity:var(--tui-disabled-opacity)}[data-platform=android] tui-badge,[data-platform=ios] tui-badge,[data-platform=android] [tuiBadge],[data-platform=ios] [tuiBadge]{font-weight:700}[data-platform=android] tui-badge[data-size=s],[data-platform=ios] tui-badge[data-size=s],[data-platform=android] [tuiBadge][data-size=s],[data-platform=ios] [tuiBadge][data-size=s]{font:var(--tui-font-text-xs);font-weight:700}[data-platform=android] tui-badge[data-size=xl],[data-platform=ios] tui-badge[data-size=xl],[data-platform=android] [tuiBadge][data-size=xl],[data-platform=ios] [tuiBadge][data-size=xl]{--t-padding: 0 .625rem;--t-size: 1.75rem;font:var(--tui-font-text-s);font-weight:700}[data-platform=android] tui-badge-notification[data-size=l],[data-platform=ios] tui-badge-notification[data-size=l]{font:var(--tui-font-text-m)}[data-platform=android] tui-badge-notification[data-size=m],[data-platform=ios] tui-badge-notification[data-size=m]{--t-size: 1.125rem}[data-platform=android] tui-block-status,[data-platform=ios] tui-block-status{padding:2rem}[data-platform=android] tui-block-status .t-block-image:not(:empty),[data-platform=ios] tui-block-status .t-block-image:not(:empty){margin-bottom:1.5rem}[data-platform=android] tui-block-status .t-block-actions:not(:empty),[data-platform=ios] tui-block-status .t-block-actions:not(:empty){margin-top:1.5rem}[data-platform=android] tui-block-status._card,[data-platform=ios] tui-block-status._card{padding:1.25rem}[data-platform=android] tui-block-status._card .t-block-image,[data-platform=ios] tui-block-status._card .t-block-image{margin-top:.75rem;margin-bottom:1rem}[data-platform=android] tui-block-status h1,[data-platform=ios] tui-block-status h1,[data-platform=android] tui-block-status h2,[data-platform=ios] tui-block-status h2,[data-platform=android] tui-block-status h3,[data-platform=ios] tui-block-status h3,[data-platform=android] tui-block-status h4,[data-platform=ios] tui-block-status h4,[data-platform=android] tui-block-status h5,[data-platform=ios] tui-block-status h5,[data-platform=android] tui-block-status h6,[data-platform=ios] tui-block-status h6{font:var(--tui-font-heading-5)}[data-platform=android] tui-block-status h1~.t-block-text:not(:empty),[data-platform=ios] tui-block-status h1~.t-block-text:not(:empty),[data-platform=android] tui-block-status h2~.t-block-text:not(:empty),[data-platform=ios] tui-block-status h2~.t-block-text:not(:empty),[data-platform=android] tui-block-status h3~.t-block-text:not(:empty),[data-platform=ios] tui-block-status h3~.t-block-text:not(:empty),[data-platform=android] tui-block-status h4~.t-block-text:not(:empty),[data-platform=ios] tui-block-status h4~.t-block-text:not(:empty),[data-platform=android] tui-block-status h5~.t-block-text:not(:empty),[data-platform=ios] tui-block-status h5~.t-block-text:not(:empty),[data-platform=android] tui-block-status h6~.t-block-text:not(:empty),[data-platform=ios] tui-block-status h6~.t-block-text:not(:empty){margin-top:.5rem}[data-platform=android] tui-block-status img,[data-platform=ios] tui-block-status img{inline-size:8rem;block-size:8rem}[data-platform=android] tui-block-status a:not(:last-child),[data-platform=ios] tui-block-status a:not(:last-child),[data-platform=android] tui-block-status button:not(:last-child),[data-platform=ios] tui-block-status button:not(:last-child){margin-bottom:.5rem}[data-platform=android] [tuiCardLarge] [tuiButton],[data-platform=ios] [tuiCardLarge] [tuiButton]{inline-size:100%}[data-platform=android] [tuiButton][data-size=xs],[data-platform=ios] [tuiButton][data-size=xs],[data-platform=android] [tuiIconButton][data-size=xs],[data-platform=ios] [tuiIconButton][data-size=xs],[data-platform=android] [tuiButton][data-size=s],[data-platform=ios] [tuiButton][data-size=s],[data-platform=android] [tuiIconButton][data-size=s],[data-platform=ios] [tuiIconButton][data-size=s],[data-platform=android] [tuiButton][data-size=l],[data-platform=ios] [tuiButton][data-size=l],[data-platform=android] [tuiIconButton][data-size=l],[data-platform=ios] [tuiIconButton][data-size=l]{--t-radius: 1rem}[data-platform=android] [tuiButton][data-size=m],[data-platform=ios] [tuiButton][data-size=m],[data-platform=android] [tuiIconButton][data-size=m],[data-platform=ios] [tuiIconButton][data-size=m]{--t-radius: .75rem}[data-platform=android] [tuiButton][data-size=l],[data-platform=ios] [tuiButton][data-size=l],[data-platform=android] [tuiIconButton][data-size=l],[data-platform=ios] [tuiIconButton][data-size=l]{font:var(--tui-font-text-l);font-weight:700}[data-platform=android] [tuiButton][data-appearance^=primary]:disabled:not(._loading),[data-platform=ios] [tuiButton][data-appearance^=primary]:disabled:not(._loading),[data-platform=android] [tuiIconButton][data-appearance^=primary]:disabled:not(._loading),[data-platform=ios] [tuiIconButton][data-appearance^=primary]:disabled:not(._loading),[data-platform=android] [tuiButton][data-appearance^=secondary]:disabled:not(._loading),[data-platform=ios] [tuiButton][data-appearance^=secondary]:disabled:not(._loading),[data-platform=android] [tuiIconButton][data-appearance^=secondary]:disabled:not(._loading),[data-platform=ios] [tuiIconButton][data-appearance^=secondary]:disabled:not(._loading),[data-platform=android] [tuiButton][data-appearance^=accent]:disabled:not(._loading),[data-platform=ios] [tuiButton][data-appearance^=accent]:disabled:not(._loading),[data-platform=android] [tuiIconButton][data-appearance^=accent]:disabled:not(._loading),[data-platform=ios] [tuiIconButton][data-appearance^=accent]:disabled:not(._loading),[data-platform=android] [tuiButton][data-appearance^=destructive]:disabled:not(._loading),[data-platform=ios] [tuiButton][data-appearance^=destructive]:disabled:not(._loading),[data-platform=android] [tuiIconButton][data-appearance^=destructive]:disabled:not(._loading),[data-platform=ios] [tuiIconButton][data-appearance^=destructive]:disabled:not(._loading),[data-platform=android] [tuiButton][data-appearance^=opposite]:disabled:not(._loading),[data-platform=ios] [tuiButton][data-appearance^=opposite]:disabled:not(._loading),[data-platform=android] [tuiIconButton][data-appearance^=opposite]:disabled:not(._loading),[data-platform=ios] [tuiIconButton][data-appearance^=opposite]:disabled:not(._loading),[data-platform=android] [tuiButton][data-appearance^=flat]:disabled:not(._loading),[data-platform=ios] [tuiButton][data-appearance^=flat]:disabled:not(._loading),[data-platform=android] [tuiIconButton][data-appearance^=flat]:disabled:not(._loading),[data-platform=ios] [tuiIconButton][data-appearance^=flat]:disabled:not(._loading),[data-platform=android] [tuiButton][data-appearance^=primary][data-state=disabled]:not(._loading),[data-platform=ios] [tuiButton][data-appearance^=primary][data-state=disabled]:not(._loading),[data-platform=android] [tuiIconButton][data-appearance^=primary][data-state=disabled]:not(._loading),[data-platform=ios] [tuiIconButton][data-appearance^=primary][data-state=disabled]:not(._loading),[data-platform=android] [tuiButton][data-appearance^=secondary][data-state=disabled]:not(._loading),[data-platform=ios] [tuiButton][data-appearance^=secondary][data-state=disabled]:not(._loading),[data-platform=android] [tuiIconButton][data-appearance^=secondary][data-state=disabled]:not(._loading),[data-platform=ios] [tuiIconButton][data-appearance^=secondary][data-state=disabled]:not(._loading),[data-platform=android] [tuiButton][data-appearance^=accent][data-state=disabled]:not(._loading),[data-platform=ios] [tuiButton][data-appearance^=accent][data-state=disabled]:not(._loading),[data-platform=android] [tuiIconButton][data-appearance^=accent][data-state=disabled]:not(._loading),[data-platform=ios] [tuiIconButton][data-appearance^=accent][data-state=disabled]:not(._loading),[data-platform=android] [tuiButton][data-appearance^=destructive][data-state=disabled]:not(._loading),[data-platform=ios] [tuiButton][data-appearance^=destructive][data-state=disabled]:not(._loading),[data-platform=android] [tuiIconButton][data-appearance^=destructive][data-state=disabled]:not(._loading),[data-platform=ios] [tuiIconButton][data-appearance^=destructive][data-state=disabled]:not(._loading),[data-platform=android] [tuiButton][data-appearance^=opposite][data-state=disabled]:not(._loading),[data-platform=ios] [tuiButton][data-appearance^=opposite][data-state=disabled]:not(._loading),[data-platform=android] [tuiIconButton][data-appearance^=opposite][data-state=disabled]:not(._loading),[data-platform=ios] [tuiIconButton][data-appearance^=opposite][data-state=disabled]:not(._loading),[data-platform=android] [tuiButton][data-appearance^=flat][data-state=disabled]:not(._loading),[data-platform=ios] [tuiButton][data-appearance^=flat][data-state=disabled]:not(._loading),[data-platform=android] [tuiIconButton][data-appearance^=flat][data-state=disabled]:not(._loading),[data-platform=ios] [tuiIconButton][data-appearance^=flat][data-state=disabled]:not(._loading){background:var(--tui-background-neutral-1);color:var(--tui-text-tertiary);opacity:1}[data-platform=android] [tuiButton][data-appearance^=primary]:disabled:not(._loading)[data-appearance^=flat],[data-platform=ios] [tuiButton][data-appearance^=primary]:disabled:not(._loading)[data-appearance^=flat],[data-platform=android] [tuiIconButton][data-appearance^=primary]:disabled:not(._loading)[data-appearance^=flat],[data-platform=ios] [tuiIconButton][data-appearance^=primary]:disabled:not(._loading)[data-appearance^=flat],[data-platform=android] [tuiButton][data-appearance^=secondary]:disabled:not(._loading)[data-appearance^=flat],[data-platform=ios] [tuiButton][data-appearance^=secondary]:disabled:not(._loading)[data-appearance^=flat],[data-platform=android] [tuiIconButton][data-appearance^=secondary]:disabled:not(._loading)[data-appearance^=flat],[data-platform=ios] [tuiIconButton][data-appearance^=secondary]:disabled:not(._loading)[data-appearance^=flat],[data-platform=android] [tuiButton][data-appearance^=accent]:disabled:not(._loading)[data-appearance^=flat],[data-platform=ios] [tuiButton][data-appearance^=accent]:disabled:not(._loading)[data-appearance^=flat],[data-platform=android] [tuiIconButton][data-appearance^=accent]:disabled:not(._loading)[data-appearance^=flat],[data-platform=ios] [tuiIconButton][data-appearance^=accent]:disabled:not(._loading)[data-appearance^=flat],[data-platform=android] [tuiButton][data-appearance^=destructive]:disabled:not(._loading)[data-appearance^=flat],[data-platform=ios] [tuiButton][data-appearance^=destructive]:disabled:not(._loading)[data-appearance^=flat],[data-platform=android] [tuiIconButton][data-appearance^=destructive]:disabled:not(._loading)[data-appearance^=flat],[data-platform=ios] [tuiIconButton][data-appearance^=destructive]:disabled:not(._loading)[data-appearance^=flat],[data-platform=android] [tuiButton][data-appearance^=opposite]:disabled:not(._loading)[data-appearance^=flat],[data-platform=ios] [tuiButton][data-appearance^=opposite]:disabled:not(._loading)[data-appearance^=flat],[data-platform=android] [tuiIconButton][data-appearance^=opposite]:disabled:not(._loading)[data-appearance^=flat],[data-platform=ios] [tuiIconButton][data-appearance^=opposite]:disabled:not(._loading)[data-appearance^=flat],[data-platform=android] [tuiButton][data-appearance^=flat]:disabled:not(._loading)[data-appearance^=flat],[data-platform=ios] [tuiButton][data-appearance^=flat]:disabled:not(._loading)[data-appearance^=flat],[data-platform=android] [tuiIconButton][data-appearance^=flat]:disabled:not(._loading)[data-appearance^=flat],[data-platform=ios] [tuiIconButton][data-appearance^=flat]:disabled:not(._loading)[data-appearance^=flat],[data-platform=android] [tuiButton][data-appearance^=primary][data-state=disabled]:not(._loading)[data-appearance^=flat],[data-platform=ios] [tuiButton][data-appearance^=primary][data-state=disabled]:not(._loading)[data-appearance^=flat],[data-platform=android] [tuiIconButton][data-appearance^=primary][data-state=disabled]:not(._loading)[data-appearance^=flat],[data-platform=ios] [tuiIconButton][data-appearance^=primary][data-state=disabled]:not(._loading)[data-appearance^=flat],[data-platform=android] [tuiButton][data-appearance^=secondary][data-state=disabled]:not(._loading)[data-appearance^=flat],[data-platform=ios] [tuiButton][data-appearance^=secondary][data-state=disabled]:not(._loading)[data-appearance^=flat],[data-platform=android] [tuiIconButton][data-appearance^=secondary][data-state=disabled]:not(._loading)[data-appearance^=flat],[data-platform=ios] [tuiIconButton][data-appearance^=secondary][data-state=disabled]:not(._loading)[data-appearance^=flat],[data-platform=android] [tuiButton][data-appearance^=accent][data-state=disabled]:not(._loading)[data-appearance^=flat],[data-platform=ios] [tuiButton][data-appearance^=accent][data-state=disabled]:not(._loading)[data-appearance^=flat],[data-platform=android] [tuiIconButton][data-appearance^=accent][data-state=disabled]:not(._loading)[data-appearance^=flat],[data-platform=ios] [tuiIconButton][data-appearance^=accent][data-state=disabled]:not(._loading)[data-appearance^=flat],[data-platform=android] [tuiButton][data-appearance^=destructive][data-state=disabled]:not(._loading)[data-appearance^=flat],[data-platform=ios] [tuiButton][data-appearance^=destructive][data-state=disabled]:not(._loading)[data-appearance^=flat],[data-platform=android] [tuiIconButton][data-appearance^=destructive][data-state=disabled]:not(._loading)[data-appearance^=flat],[data-platform=ios] [tuiIconButton][data-appearance^=destructive][data-state=disabled]:not(._loading)[data-appearance^=flat],[data-platform=android] [tuiButton][data-appearance^=opposite][data-state=disabled]:not(._loading)[data-appearance^=flat],[data-platform=ios] [tuiButton][data-appearance^=opposite][data-state=disabled]:not(._loading)[data-appearance^=flat],[data-platform=android] [tuiIconButton][data-appearance^=opposite][data-state=disabled]:not(._loading)[data-appearance^=flat],[data-platform=ios] [tuiIconButton][data-appearance^=opposite][data-state=disabled]:not(._loading)[data-appearance^=flat],[data-platform=android] [tuiButton][data-appearance^=flat][data-state=disabled]:not(._loading)[data-appearance^=flat],[data-platform=ios] [tuiButton][data-appearance^=flat][data-state=disabled]:not(._loading)[data-appearance^=flat],[data-platform=android] [tuiIconButton][data-appearance^=flat][data-state=disabled]:not(._loading)[data-appearance^=flat],[data-platform=ios] [tuiIconButton][data-appearance^=flat][data-state=disabled]:not(._loading)[data-appearance^=flat]{background:transparent}[data-platform=android] [tuiButton][tuiButtonVertical],[data-platform=ios] [tuiButton][tuiButtonVertical]{gap:.5rem}[data-platform=android] [tuiItemGroup],[data-platform=ios] [tuiItemGroup]{--tui-item-margin: .5rem}[data-platform=android] [tuiTitle],[data-platform=ios] [tuiTitle]{gap:.25rem}[data-platform=android] [tuiTitle] [tuiSubtitle],[data-platform=ios] [tuiTitle] [tuiSubtitle]{color:var(--tui-text-secondary)}[data-platform=android] [tuiCardLarge][data-space][data-space=normal],[data-platform=ios] [tuiCardLarge][data-space][data-space=normal]{--t-padding: 1.25rem;--t-space: 1.25rem}[data-platform=android] [tuiCardLarge][data-space][data-space=compact],[data-platform=ios] [tuiCardLarge][data-space][data-space=compact]{--t-padding: 1rem;--t-space: 1rem;--t-comp: -.125rem}[data-platform=android] tui-chip,[data-platform=ios] tui-chip,[data-platform=android] [tuiChip],[data-platform=ios] [tuiChip]{border-radius:2rem}[data-platform=android] tui-chip[data-size=s],[data-platform=ios] tui-chip[data-size=s],[data-platform=android] [tuiChip][data-size=s],[data-platform=ios] [tuiChip][data-size=s]{--t-size: 1.875rem;--t-padding: .6875rem}[data-platform=android] tui-chip[data-size=m],[data-platform=ios] tui-chip[data-size=m],[data-platform=android] [tuiChip][data-size=m],[data-platform=ios] [tuiChip][data-size=m]{--t-size: 2rem;--t-padding: .875rem}[data-platform=android] tui-segmented[data-size],[data-platform=ios] tui-segmented[data-size]{--t-padding: .625rem;--t-gap: .625rem;--t-margin: -.25rem;--t-height: var(--tui-height-s);font:var(--tui-font-text-s);border-radius:.625rem}[data-platform=android] tui-segmented[data-size] tui-icon,[data-platform=ios] tui-segmented[data-size] tui-icon{font-size:1rem}[data-platform=android] [tuiHeader][data-size=xxl] [tuiTitle],[data-platform=ios] [tuiHeader][data-size=xxl] [tuiTitle],[data-platform=android] [tuiHeader][data-size=xl] [tuiTitle],[data-platform=ios] [tuiHeader][data-size=xl] [tuiTitle],[data-platform=android] [tuiHeader][data-size=l] [tuiTitle],[data-platform=ios] [tuiHeader][data-size=l] [tuiTitle],[data-platform=android] [tuiHeader][data-size=h1] [tuiTitle],[data-platform=ios] [tuiHeader][data-size=h1] [tuiTitle],[data-platform=android] [tuiHeader][data-size=h2] [tuiTitle],[data-platform=ios] [tuiHeader][data-size=h2] [tuiTitle],[data-platform=android] [tuiHeader][data-size=h3] [tuiTitle],[data-platform=ios] [tuiHeader][data-size=h3] [tuiTitle]{gap:1rem}[data-platform=android] [tuiHeader][data-size=m] [tuiTitle],[data-platform=ios] [tuiHeader][data-size=m] [tuiTitle],[data-platform=android] [tuiHeader][data-size=h4] [tuiTitle],[data-platform=ios] [tuiHeader][data-size=h4] [tuiTitle]{gap:.5rem}[data-platform=android] [tuiHeader] [tuiAccessories],[data-platform=ios] [tuiHeader] [tuiAccessories]{gap:1rem}[data-platform=android] [tuiHeader][data-size=xxs] [tuiTitle],[data-platform=ios] [tuiHeader][data-size=xxs] [tuiTitle],[data-platform=android] [tuiHeader][data-size=h6] [tuiTitle],[data-platform=ios] [tuiHeader][data-size=h6] [tuiTitle],[data-platform=android] [tuiHeader][data-size=body-l] [tuiTitle],[data-platform=ios] [tuiHeader][data-size=body-l] [tuiTitle],[data-platform=android] [tuiHeader][data-size=body-m] [tuiTitle],[data-platform=ios] [tuiHeader][data-size=body-m] [tuiTitle],[data-platform=android] [tuiHeader][data-size=xxs] [tuiAccessories],[data-platform=ios] [tuiHeader][data-size=xxs] [tuiAccessories],[data-platform=android] [tuiHeader][data-size=h6] [tuiAccessories],[data-platform=ios] [tuiHeader][data-size=h6] [tuiAccessories],[data-platform=android] [tuiHeader][data-size=body-l] [tuiAccessories],[data-platform=ios] [tuiHeader][data-size=body-l] [tuiAccessories],[data-platform=android] [tuiHeader][data-size=body-m] [tuiAccessories],[data-platform=ios] [tuiHeader][data-size=body-m] [tuiAccessories]{font:var(--tui-font-heading-6)}[data-platform=android] [tuiMessage],[data-platform=ios] [tuiMessage]{font:var(--tui-font-text-l);border-radius:.875rem}@keyframes tuiReveal{0%{transform:scale(0)}to{transform:scale(1)}}@keyframes tuiFadeIn{0%{opacity:var(--tui-fade-start, 0)}to{opacity:var(--tui-fade-end, 1)}}html{block-size:100%;font-size:16px}body{block-size:100%;min-block-size:100%;text-rendering:optimizeLegibility;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}html,body{-webkit-overflow-scrolling:touch}ul,ol{list-style:none;padding:0;margin:0}table{border-collapse:collapse;border-spacing:0}input,button,select,textarea{font-family:inherit;color:inherit}hr{margin:0;block-size:1px;border:none;background:var(--tui-border-normal)}iframe{border:none}svg use{pointer-events:none}::selection{background-color:var(--tui-service-selection-background)}::-ms-clear{display:none}::-ms-reveal{display:none}@supports (-webkit-hyphens: none) and (text-align-last: right){:after{content:none}}.tui-container{margin-right:auto;margin-left:auto}@media screen and (min-width: 80em){.tui-container.tui-container_adaptive{inline-size:69rem}}@media screen and (max-width: 79.9625em){.tui-container.tui-container_adaptive{inline-size:51.5rem}}@media screen and (max-width: 47.9625em){.tui-container.tui-container_adaptive{inline-size:100%;padding:0 1rem;box-sizing:border-box}}@media screen and (min-width: 80em){.tui-container{inline-size:69rem}}@media screen and (max-width: 79.9625em){.tui-container{inline-size:51.5rem;padding:0 3rem}}@media screen and (min-width: 80em){.tui-container_menu{inline-size:69rem}}@media (min-width: 64em) and (max-width: 79.9625em){.tui-container_menu{inline-size:51.5rem}}@media screen and (max-width: 47.9625em){.tui-container_menu{inline-size:auto;padding:0 1rem;box-sizing:border-box}}.tui-container_fullwidth{inline-size:auto;padding:0 1.5rem}@media screen and (max-width: 47.9625em){.tui-container_fullwidth{padding:0 1rem;box-sizing:border-box}}@media screen and (max-width: 79.9625em){.tui-container_fixed{inline-size:69rem}}.tui-form__header{font:var(--tui-font-heading-5);margin-top:2rem;margin-bottom:1.25rem}@media screen and (max-width: 47.9625em){.tui-form__header{font:var(--tui-font-text-l);font-weight:700;margin-bottom:1rem}}.tui-form__header_margin-top_none{margin-top:0}.tui-form__header_margin-bottom_none{margin-bottom:0}.tui-form__header_margin-bottom_small{margin-bottom:1rem}@media screen and (max-width: 47.9625em){.tui-form__header_margin-bottom_small{margin-bottom:.75rem}}.tui-form__row{margin-top:1.25rem}.tui-form__row:first-child{margin-top:0}.tui-form__row_multi-fields{display:flex}@media screen and (max-width: 47.9625em){.tui-form__row_multi-fields{flex-wrap:wrap}}.tui-form__row_half-width{inline-size:calc(50% - .625rem)}@media screen and (max-width: 47.9625em){.tui-form__row_half-width{inline-size:100%}}.tui-form__row_checkboxes{display:flex;flex-wrap:wrap}@media screen and (max-width: 47.9625em){.tui-form__row{margin-top:1rem}}.tui-form__multi-field{flex:1 1 0;min-inline-size:0;margin-left:1.25rem}.tui-form__multi-field:first-child{margin-left:0}@media screen and (max-width: 47.9625em){.tui-form__multi-field{flex-basis:100%;margin-top:1rem;margin-left:0}.tui-form__multi-field:first-child{margin-top:0}}.tui-form__field-note{font:var(--tui-font-text-s);margin-top:.25rem;color:var(--tui-text-secondary)}.tui-form__field-checkbox{margin-top:.5rem}.tui-form__checkbox{flex:1 1 calc(50% - .625rem)}.tui-form__checkbox:nth-child(2n){margin-left:1.25rem}.tui-form__checkbox:nth-child(n+3){margin-top:1rem}.tui-form__buttons{display:flex;margin-top:2rem}.tui-form__buttons_align_end{justify-content:flex-end}.tui-form__buttons_align_center{justify-content:center}@media screen and (max-width: 47.9625em){.tui-form__buttons{flex-direction:column;margin-top:1.5rem}}.tui-form__button{margin-left:.75rem}.tui-form__button:first-child{margin-left:0}@media screen and (max-width: 47.9625em){.tui-form__button{margin-top:.5rem;margin-left:0}}.tui-island{position:relative;display:block;border-radius:var(--tui-radius-xl);background-color:var(--tui-background-base);overflow-wrap:break-word;text-decoration:none;color:var(--tui-text-primary);outline:none;box-sizing:content-box}.tui-island:not(.tui-island_hoverable):before{position:absolute;top:0;left:0;inline-size:100%;block-size:100%;content:"";box-sizing:border-box;border:1px solid var(--tui-border-normal);border-radius:inherit;pointer-events:none}.tui-island:focus:before,.tui-island:hover:focus:before{border-color:var(--tui-border-focus)}.tui-island_hoverable{transition-property:all;transition-duration:var(--tui-duration, .3s);transition-timing-function:ease-in-out;background:var(--tui-background-elevation-2);box-shadow:var(--tui-shadow-small);cursor:pointer;transition-property:transform,box-shadow;will-change:transform,box-shadow}.tui-island_hoverable:hover{box-shadow:var(--tui-shadow-small-hover);transform:translateY(-.25rem)}.tui-island_transparent{background-color:transparent}.tui-island_size_s{--tui-radius-xl: calc(4 * var(--tui-radius-l) / 3);font:var(--tui-font-text-s);padding:1rem}.tui-island_size_m{--tui-radius-xl: calc(5 * var(--tui-radius-l) / 3);font:var(--tui-font-text-m);padding:1rem}.tui-island_size_l{font:var(--tui-font-text-m);padding:1.25rem}.tui-island_text-align_left{text-align:start}.tui-island_text-align_center{text-align:center}.tui-island_text-align_right{text-align:end}.tui-island__content{display:flex;justify-content:space-between}.tui-island_text-align_center .tui-island__content{display:block}.tui-island__content>*{min-inline-size:0}.tui-island__category{font-size:.6875rem;line-height:1rem;text-transform:uppercase;letter-spacing:.075em;margin:0 0 .5rem;color:var(--tui-text-secondary)}.tui-island_size_l .tui-island__category{margin:0 0 .75rem}.tui-island__title{font:var(--tui-font-text-m);margin:0 0 .5rem}.tui-island_size_m .tui-island__title{font:var(--tui-font-heading-6);margin:0 0 .75rem}.tui-island_size_l .tui-island__title{font:var(--tui-font-heading-6)}.tui-island__paragraph{margin:0;color:var(--tui-text-secondary)}.tui-island__paragraph_link.tui-island__paragraph{margin-top:1rem}.tui-island_size_l .tui-island__paragraph_link.tui-island__paragraph{margin:1rem 0 0}.tui-island__paragraph_button.tui-island__paragraph{margin-top:1.25rem}.tui-island_size_l .tui-island__paragraph_button.tui-island__paragraph{margin:1.25rem 0 0}.tui-island__figure{display:flex;justify-content:center;order:1;flex-shrink:0;margin:0 0 0 1rem}.tui-island_size_l .tui-island__figure{margin-left:2.25rem}.tui-island_text-align_center .tui-island__figure{margin:0 0 .75rem}.tui-island__carousel-controls{display:flex;padding-bottom:1rem;margin-bottom:1rem;border-block-end:1px solid var(--tui-border-normal);white-space:nowrap}.tui-island__carousel-pages{margin-left:auto;color:var(--tui-text-secondary)}.tui-island__carousel-button{margin-right:.5rem}.tui-island .tui-island__footer-button{display:block;max-inline-size:unset;inline-size:calc(100% + 1.875rem);margin:1rem calc(-1rem + 1px) calc(-1rem + 1px);border-block-start:1px solid var(--tui-border-normal);border-radius:0 0 var(--tui-radius-xl) var(--tui-radius-xl)}.tui-island_size_l .tui-island__footer-button{inline-size:calc(100% + 2.375rem);margin:1.25rem calc(-1.25rem + 1px) calc(-1.25rem + 1px)}.tui-island__marker:first-child:not(:only-child){margin-right:1.25rem}.tui-island__marker:not(:first-child),.tui-island__marker:only-child{margin-left:1.25rem}.tui-list{font:var(--tui-font-text-m);line-height:1.5rem;list-style-type:none;color:var(--tui-text-primary)}.tui-list_large{font:var(--tui-font-text-l);line-height:1.75rem}.tui-list_small,.tui-list_extra-small{font:var(--tui-font-text-s);line-height:1.25rem}.tui-list_nested{margin:.75rem 0 .75rem 1.25rem;color:var(--tui-text-secondary)}.tui-list_large .tui-list_nested{margin-left:.75rem}.tui-list_small .tui-list_nested{margin-top:.5rem;margin-bottom:.5rem}.tui-list_ordered{counter-reset:counter}.tui-list__item{position:relative;padding-left:1.5rem;overflow-wrap:break-word;margin-top:.75rem}.tui-list__item:first-child{margin-top:0}.tui-list__item:before{content:"";position:absolute;left:0;top:.5rem;inline-size:.5rem;block-size:.5rem;border-radius:100%;background-color:var(--tui-background-accent-1)}.tui-list_large>.tui-list__item:before{top:.625rem}.tui-list_small>.tui-list__item:before{top:.325rem}.tui-list_extra-small>.tui-list__item{margin-top:.5rem}.tui-list_linear .tui-list__item{padding-left:1.75rem}.tui-list_linear .tui-list__item:before{content:"\\2014";left:0;top:auto;inline-size:auto;block-size:auto;background-color:transparent}.tui-list_ordered .tui-list__item{padding-left:1.25rem}.tui-list_ordered .tui-list__item:before{content:counter(counter) ".";left:0;top:auto;counter-increment:counter;inline-size:auto;block-size:auto;color:var(--tui-text-tertiary);background-color:transparent}.tui-list_triangle>.tui-list__item{padding-left:1.75rem}.tui-list_triangle>.tui-list__item:before{content:"\\25e4";left:0;top:1px;inline-size:auto;block-size:auto;background-color:transparent;color:var(--tui-text-tertiary);font-size:.75rem}.tui-list__item-title{font:var(--tui-font-heading-5);margin:0}.tui-list_small .tui-list__item-title{line-height:1.25rem;font-weight:700}.tui-list__description{margin:.5rem 0 0;color:var(--tui-text-secondary)}.tui-list_small .tui-list__description{margin-top:.25rem}.tui-list_large .tui-list__description{line-height:1.75rem;margin-top:.75rem}@media not screen and (max-width: 47.9625em){.tui-mobile-only{display:none!important}}.tui-required:after{content:"*"}.tui-required_float:after{position:absolute}.tui-required_spacing:after{content:"\\a0*"}.tui-row{display:flex;flex-wrap:wrap}.tui-row_align_center{align-items:center}.tui-row_align_start{align-items:flex-start}.tui-row_align_end{align-items:flex-end}@media screen and (min-width: 80em){.tui-row_adaptive.tui-row{margin-left:-1.5rem;margin-right:-1.5rem}}@media screen and (max-width: 79.9625em){.tui-row_adaptive.tui-row{margin-left:-1.25rem;margin-right:-1.25rem}}@media screen and (max-width: 47.9625em){.tui-row_adaptive.tui-row{margin-left:-.5rem;margin-right:-.5rem}}.tui-row_temporary.tui-row{margin-left:-1.25rem;margin-right:-1.25rem}@media screen and (min-width: 80em){.tui-row{margin-left:-1.5rem;margin-right:-1.5rem}}@media screen and (max-width: 79.9625em){.tui-row{margin-left:-1.25rem;margin-right:-1.25rem}}.tui-col_1{inline-size:8.33333333%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-col_2{inline-size:16.66666667%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-col_3{inline-size:25%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-col_4{inline-size:33.33333333%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-col_5{inline-size:41.66666667%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-col_6{inline-size:50%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-col_7{inline-size:58.33333333%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-col_8{inline-size:66.66666667%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-col_9{inline-size:75%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-col_10{inline-size:83.33333333%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-col_11{inline-size:91.66666667%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-col_12{inline-size:100%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-col_md-1{inline-size:8.33333333%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-col_md-2{inline-size:16.66666667%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-col_md-3{inline-size:25%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-col_md-4{inline-size:33.33333333%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-col_md-5{inline-size:41.66666667%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-col_md-6{inline-size:50%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-col_md-7{inline-size:58.33333333%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-col_md-8{inline-size:66.66666667%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-col_md-9{inline-size:75%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-col_md-10{inline-size:83.33333333%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-col_md-11{inline-size:91.66666667%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-col_md-12{inline-size:100%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-col_stretch{display:flex}@media screen and (min-width: 80em){.tui-row_adaptive .tui-col_lg-1{inline-size:8.33333333%;padding-left:1.5rem;padding-right:1.5rem;box-sizing:border-box}.tui-row_adaptive .tui-col_lg-2{inline-size:16.66666667%;padding-left:1.5rem;padding-right:1.5rem;box-sizing:border-box}.tui-row_adaptive .tui-col_lg-3{inline-size:25%;padding-left:1.5rem;padding-right:1.5rem;box-sizing:border-box}.tui-row_adaptive .tui-col_lg-4{inline-size:33.33333333%;padding-left:1.5rem;padding-right:1.5rem;box-sizing:border-box}.tui-row_adaptive .tui-col_lg-5{inline-size:41.66666667%;padding-left:1.5rem;padding-right:1.5rem;box-sizing:border-box}.tui-row_adaptive .tui-col_lg-6{inline-size:50%;padding-left:1.5rem;padding-right:1.5rem;box-sizing:border-box}.tui-row_adaptive .tui-col_lg-7{inline-size:58.33333333%;padding-left:1.5rem;padding-right:1.5rem;box-sizing:border-box}.tui-row_adaptive .tui-col_lg-8{inline-size:66.66666667%;padding-left:1.5rem;padding-right:1.5rem;box-sizing:border-box}.tui-row_adaptive .tui-col_lg-9{inline-size:75%;padding-left:1.5rem;padding-right:1.5rem;box-sizing:border-box}.tui-row_adaptive .tui-col_lg-10{inline-size:83.33333333%;padding-left:1.5rem;padding-right:1.5rem;box-sizing:border-box}.tui-row_adaptive .tui-col_lg-11{inline-size:91.66666667%;padding-left:1.5rem;padding-right:1.5rem;box-sizing:border-box}.tui-row_adaptive .tui-col_lg-12{inline-size:100%;padding-left:1.5rem;padding-right:1.5rem;box-sizing:border-box}}@media screen and (max-width: 79.9625em){.tui-row_adaptive .tui-col_md-1{inline-size:8.33333333%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-row_adaptive .tui-col_md-2{inline-size:16.66666667%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-row_adaptive .tui-col_md-3{inline-size:25%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-row_adaptive .tui-col_md-4{inline-size:33.33333333%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-row_adaptive .tui-col_md-5{inline-size:41.66666667%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-row_adaptive .tui-col_md-6{inline-size:50%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-row_adaptive .tui-col_md-7{inline-size:58.33333333%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-row_adaptive .tui-col_md-8{inline-size:66.66666667%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-row_adaptive .tui-col_md-9{inline-size:75%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-row_adaptive .tui-col_md-10{inline-size:83.33333333%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-row_adaptive .tui-col_md-11{inline-size:91.66666667%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-row_adaptive .tui-col_md-12{inline-size:100%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}}@media screen and (max-width: 47.9625em){.tui-row_adaptive .tui-col_xs-1{inline-size:8.33333333%;padding-left:.5rem;padding-right:.5rem;box-sizing:border-box}.tui-row_adaptive .tui-col_xs-2{inline-size:16.66666667%;padding-left:.5rem;padding-right:.5rem;box-sizing:border-box}.tui-row_adaptive .tui-col_xs-3{inline-size:25%;padding-left:.5rem;padding-right:.5rem;box-sizing:border-box}.tui-row_adaptive .tui-col_xs-4{inline-size:33.33333333%;padding-left:.5rem;padding-right:.5rem;box-sizing:border-box}.tui-row_adaptive .tui-col_xs-5{inline-size:41.66666667%;padding-left:.5rem;padding-right:.5rem;box-sizing:border-box}.tui-row_adaptive .tui-col_xs-6{inline-size:50%;padding-left:.5rem;padding-right:.5rem;box-sizing:border-box}.tui-row_adaptive .tui-col_xs-7{inline-size:58.33333333%;padding-left:.5rem;padding-right:.5rem;box-sizing:border-box}.tui-row_adaptive .tui-col_xs-8{inline-size:66.66666667%;padding-left:.5rem;padding-right:.5rem;box-sizing:border-box}.tui-row_adaptive .tui-col_xs-9{inline-size:75%;padding-left:.5rem;padding-right:.5rem;box-sizing:border-box}.tui-row_adaptive .tui-col_xs-10{inline-size:83.33333333%;padding-left:.5rem;padding-right:.5rem;box-sizing:border-box}.tui-row_adaptive .tui-col_xs-11{inline-size:91.66666667%;padding-left:.5rem;padding-right:.5rem;box-sizing:border-box}.tui-row_adaptive .tui-col_xs-12{inline-size:100%;padding-left:.5rem;padding-right:.5rem;box-sizing:border-box}}.tui-row_temporary .tui-col_1{inline-size:8.33333333%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-row_temporary .tui-col_2{inline-size:16.66666667%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-row_temporary .tui-col_3{inline-size:25%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-row_temporary .tui-col_4{inline-size:33.33333333%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-row_temporary .tui-col_5{inline-size:41.66666667%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-row_temporary .tui-col_6{inline-size:50%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-row_temporary .tui-col_7{inline-size:58.33333333%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-row_temporary .tui-col_8{inline-size:66.66666667%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-row_temporary .tui-col_9{inline-size:75%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-row_temporary .tui-col_10{inline-size:83.33333333%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-row_temporary .tui-col_11{inline-size:91.66666667%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}.tui-row_temporary .tui-col_12{inline-size:100%;padding-left:1.25rem;padding-right:1.25rem;box-sizing:border-box}@media screen and (min-width: 80em){.tui-col_1{inline-size:8.33333333%;padding-left:1.5rem;padding-right:1.5rem;box-sizing:border-box}.tui-col_2{inline-size:16.66666667%;padding-left:1.5rem;padding-right:1.5rem;box-sizing:border-box}.tui-col_3{inline-size:25%;padding-left:1.5rem;padding-right:1.5rem;box-sizing:border-box}.tui-col_4{inline-size:33.33333333%;padding-left:1.5rem;padding-right:1.5rem;box-sizing:border-box}.tui-col_5{inline-size:41.66666667%;padding-left:1.5rem;padding-right:1.5rem;box-sizing:border-box}.tui-col_6{inline-size:50%;padding-left:1.5rem;padding-right:1.5rem;box-sizing:border-box}.tui-col_7{inline-size:58.33333333%;padding-left:1.5rem;padding-right:1.5rem;box-sizing:border-box}.tui-col_8{inline-size:66.66666667%;padding-left:1.5rem;padding-right:1.5rem;box-sizing:border-box}.tui-col_9{inline-size:75%;padding-left:1.5rem;padding-right:1.5rem;box-sizing:border-box}.tui-col_10{inline-size:83.33333333%;padding-left:1.5rem;padding-right:1.5rem;box-sizing:border-box}.tui-col_11{inline-size:91.66666667%;padding-left:1.5rem;padding-right:1.5rem;box-sizing:border-box}.tui-col_12{inline-size:100%;padding-left:1.5rem;padding-right:1.5rem;box-sizing:border-box}}.tui-col-offset_1{margin-left:8.33333333%}.tui-col-offset_2{margin-left:16.66666667%}.tui-col-offset_3{margin-left:25%}.tui-col-offset_4{margin-left:33.33333333%}.tui-col-offset_5{margin-left:41.66666667%}.tui-col-offset_6{margin-left:50%}.tui-col-offset_7{margin-left:58.33333333%}.tui-col-offset_8{margin-left:66.66666667%}.tui-col-offset_9{margin-left:75%}.tui-col-offset_10{margin-left:83.33333333%}.tui-col-offset_11{margin-left:91.66666667%}.tui-col-offset_12{margin-left:100%}@media (min-width: 22.5em) and (max-width: 47.9625em){.tui-col-offset_xs-1{margin-left:8.33333333%}.tui-col-offset_xs-2{margin-left:16.66666667%}.tui-col-offset_xs-3{margin-left:25%}.tui-col-offset_xs-4{margin-left:33.33333333%}.tui-col-offset_xs-5{margin-left:41.66666667%}.tui-col-offset_xs-6{margin-left:50%}.tui-col-offset_xs-7{margin-left:58.33333333%}.tui-col-offset_xs-8{margin-left:66.66666667%}.tui-col-offset_xs-9{margin-left:75%}.tui-col-offset_xs-10{margin-left:83.33333333%}.tui-col-offset_xs-11{margin-left:91.66666667%}.tui-col-offset_xs-12{margin-left:100%}}@media screen and (max-width: 79.9625em){.tui-col-offset_md-1{margin-left:8.33333333%}.tui-col-offset_md-2{margin-left:16.66666667%}.tui-col-offset_md-3{margin-left:25%}.tui-col-offset_md-4{margin-left:33.33333333%}.tui-col-offset_md-5{margin-left:41.66666667%}.tui-col-offset_md-6{margin-left:50%}.tui-col-offset_md-7{margin-left:58.33333333%}.tui-col-offset_md-8{margin-left:66.66666667%}.tui-col-offset_md-9{margin-left:75%}.tui-col-offset_md-10{margin-left:83.33333333%}.tui-col-offset_md-11{margin-left:91.66666667%}.tui-col-offset_md-12{margin-left:100%}}@media screen and (min-width: 80em){.tui-col-offset_lg-1{margin-left:8.33333333%}.tui-col-offset_lg-2{margin-left:16.66666667%}.tui-col-offset_lg-3{margin-left:25%}.tui-col-offset_lg-4{margin-left:33.33333333%}.tui-col-offset_lg-5{margin-left:41.66666667%}.tui-col-offset_lg-6{margin-left:50%}.tui-col-offset_lg-7{margin-left:58.33333333%}.tui-col-offset_lg-8{margin-left:66.66666667%}.tui-col-offset_lg-9{margin-left:75%}.tui-col-offset_lg-10{margin-left:83.33333333%}.tui-col-offset_lg-11{margin-left:91.66666667%}.tui-col-offset_lg-12{margin-left:100%}}.tui-skeleton{position:relative;color:transparent!important;background:transparent!important;pointer-events:none;-webkit-user-select:none;user-select:none}.tui-skeleton:after{position:absolute;top:0;left:0;inline-size:100%;block-size:100%;content:"";background-color:var(--tui-background-neutral-2);animation:tuiSkeletonVibe ease-in-out 1s infinite alternate;border-radius:var(--tui-skeleton-radius, 0)}.tui-skeleton_light:after{background-color:#ffffff3d}.tui-skeleton_rounded:after{border-radius:inherit}.tui-skeleton_short:after{inline-size:40%}.tui-skeleton_center:after{position:absolute;left:50%;transform:translate(-50%);inline-size:40%}.tui-skeleton_text:before{content:"\\a0"}.tui-skeleton *{opacity:0;visibility:hidden}.tui-space_all-16.tui-space_all-16{margin:4rem}.tui-space_all-15.tui-space_all-15{margin:3.75rem}.tui-space_all-14.tui-space_all-14{margin:3.5rem}.tui-space_all-13.tui-space_all-13{margin:3.25rem}.tui-space_all-12.tui-space_all-12{margin:3rem}.tui-space_all-11.tui-space_all-11{margin:2.75rem}.tui-space_all-10.tui-space_all-10{margin:2.5rem}.tui-space_all-9.tui-space_all-9{margin:2.25rem}.tui-space_all-8.tui-space_all-8{margin:2rem}.tui-space_all-7.tui-space_all-7{margin:1.75rem}.tui-space_all-6.tui-space_all-6{margin:1.5rem}.tui-space_all-5.tui-space_all-5{margin:1.25rem}.tui-space_all-4.tui-space_all-4{margin:1rem}.tui-space_all-3.tui-space_all-3{margin:.75rem}.tui-space_all-2.tui-space_all-2{margin:.5rem}.tui-space_all-1.tui-space_all-1{margin:.25rem}.tui-space_all-0.tui-space_all-0{margin:0rem}.tui-space_top-16.tui-space_top-16{margin-top:4rem}.tui-space_top-15.tui-space_top-15{margin-top:3.75rem}.tui-space_top-14.tui-space_top-14{margin-top:3.5rem}.tui-space_top-13.tui-space_top-13{margin-top:3.25rem}.tui-space_top-12.tui-space_top-12{margin-top:3rem}.tui-space_top-11.tui-space_top-11{margin-top:2.75rem}.tui-space_top-10.tui-space_top-10{margin-top:2.5rem}.tui-space_top-9.tui-space_top-9{margin-top:2.25rem}.tui-space_top-8.tui-space_top-8{margin-top:2rem}.tui-space_top-7.tui-space_top-7{margin-top:1.75rem}.tui-space_top-6.tui-space_top-6{margin-top:1.5rem}.tui-space_top-5.tui-space_top-5{margin-top:1.25rem}.tui-space_top-4.tui-space_top-4{margin-top:1rem}.tui-space_top-3.tui-space_top-3{margin-top:.75rem}.tui-space_top-2.tui-space_top-2{margin-top:.5rem}.tui-space_top-1.tui-space_top-1{margin-top:.25rem}.tui-space_top-0.tui-space_top-0{margin-top:0rem}.tui-space_bottom-16.tui-space_bottom-16{margin-bottom:4rem}.tui-space_bottom-15.tui-space_bottom-15{margin-bottom:3.75rem}.tui-space_bottom-14.tui-space_bottom-14{margin-bottom:3.5rem}.tui-space_bottom-13.tui-space_bottom-13{margin-bottom:3.25rem}.tui-space_bottom-12.tui-space_bottom-12{margin-bottom:3rem}.tui-space_bottom-11.tui-space_bottom-11{margin-bottom:2.75rem}.tui-space_bottom-10.tui-space_bottom-10{margin-bottom:2.5rem}.tui-space_bottom-9.tui-space_bottom-9{margin-bottom:2.25rem}.tui-space_bottom-8.tui-space_bottom-8{margin-bottom:2rem}.tui-space_bottom-7.tui-space_bottom-7{margin-bottom:1.75rem}.tui-space_bottom-6.tui-space_bottom-6{margin-bottom:1.5rem}.tui-space_bottom-5.tui-space_bottom-5{margin-bottom:1.25rem}.tui-space_bottom-4.tui-space_bottom-4{margin-bottom:1rem}.tui-space_bottom-3.tui-space_bottom-3{margin-bottom:.75rem}.tui-space_bottom-2.tui-space_bottom-2{margin-bottom:.5rem}.tui-space_bottom-1.tui-space_bottom-1{margin-bottom:.25rem}.tui-space_bottom-0.tui-space_bottom-0{margin-bottom:0rem}.tui-space_vertical-16.tui-space_vertical-16{margin-top:4rem;margin-bottom:4rem}.tui-space_vertical-15.tui-space_vertical-15{margin-top:3.75rem;margin-bottom:3.75rem}.tui-space_vertical-14.tui-space_vertical-14{margin-top:3.5rem;margin-bottom:3.5rem}.tui-space_vertical-13.tui-space_vertical-13{margin-top:3.25rem;margin-bottom:3.25rem}.tui-space_vertical-12.tui-space_vertical-12{margin-top:3rem;margin-bottom:3rem}.tui-space_vertical-11.tui-space_vertical-11{margin-top:2.75rem;margin-bottom:2.75rem}.tui-space_vertical-10.tui-space_vertical-10{margin-top:2.5rem;margin-bottom:2.5rem}.tui-space_vertical-9.tui-space_vertical-9{margin-top:2.25rem;margin-bottom:2.25rem}.tui-space_vertical-8.tui-space_vertical-8{margin-top:2rem;margin-bottom:2rem}.tui-space_vertical-7.tui-space_vertical-7{margin-top:1.75rem;margin-bottom:1.75rem}.tui-space_vertical-6.tui-space_vertical-6{margin-top:1.5rem;margin-bottom:1.5rem}.tui-space_vertical-5.tui-space_vertical-5{margin-top:1.25rem;margin-bottom:1.25rem}.tui-space_vertical-4.tui-space_vertical-4{margin-top:1rem;margin-bottom:1rem}.tui-space_vertical-3.tui-space_vertical-3{margin-top:.75rem;margin-bottom:.75rem}.tui-space_vertical-2.tui-space_vertical-2{margin-top:.5rem;margin-bottom:.5rem}.tui-space_vertical-1.tui-space_vertical-1{margin-top:.25rem;margin-bottom:.25rem}.tui-space_vertical-0.tui-space_vertical-0{margin-top:0rem;margin-bottom:0rem}.tui-space_left-16.tui-space_left-16{margin-left:4rem}.tui-space_left-15.tui-space_left-15{margin-left:3.75rem}.tui-space_left-14.tui-space_left-14{margin-left:3.5rem}.tui-space_left-13.tui-space_left-13{margin-left:3.25rem}.tui-space_left-12.tui-space_left-12{margin-left:3rem}.tui-space_left-11.tui-space_left-11{margin-left:2.75rem}.tui-space_left-10.tui-space_left-10{margin-left:2.5rem}.tui-space_left-9.tui-space_left-9{margin-left:2.25rem}.tui-space_left-8.tui-space_left-8{margin-left:2rem}.tui-space_left-7.tui-space_left-7{margin-left:1.75rem}.tui-space_left-6.tui-space_left-6{margin-left:1.5rem}.tui-space_left-5.tui-space_left-5{margin-left:1.25rem}.tui-space_left-4.tui-space_left-4{margin-left:1rem}.tui-space_left-3.tui-space_left-3{margin-left:.75rem}.tui-space_left-2.tui-space_left-2{margin-left:.5rem}.tui-space_left-1.tui-space_left-1{margin-left:.25rem}.tui-space_left-0.tui-space_left-0{margin-left:0rem}.tui-space_right-16.tui-space_right-16{margin-right:4rem}.tui-space_right-15.tui-space_right-15{margin-right:3.75rem}.tui-space_right-14.tui-space_right-14{margin-right:3.5rem}.tui-space_right-13.tui-space_right-13{margin-right:3.25rem}.tui-space_right-12.tui-space_right-12{margin-right:3rem}.tui-space_right-11.tui-space_right-11{margin-right:2.75rem}.tui-space_right-10.tui-space_right-10{margin-right:2.5rem}.tui-space_right-9.tui-space_right-9{margin-right:2.25rem}.tui-space_right-8.tui-space_right-8{margin-right:2rem}.tui-space_right-7.tui-space_right-7{margin-right:1.75rem}.tui-space_right-6.tui-space_right-6{margin-right:1.5rem}.tui-space_right-5.tui-space_right-5{margin-right:1.25rem}.tui-space_right-4.tui-space_right-4{margin-right:1rem}.tui-space_right-3.tui-space_right-3{margin-right:.75rem}.tui-space_right-2.tui-space_right-2{margin-right:.5rem}.tui-space_right-1.tui-space_right-1{margin-right:.25rem}.tui-space_right-0.tui-space_right-0{margin-right:0rem}.tui-space_horizontal-16.tui-space_horizontal-16{margin-right:4rem;margin-left:4rem}.tui-space_horizontal-15.tui-space_horizontal-15{margin-right:3.75rem;margin-left:3.75rem}.tui-space_horizontal-14.tui-space_horizontal-14{margin-right:3.5rem;margin-left:3.5rem}.tui-space_horizontal-13.tui-space_horizontal-13{margin-right:3.25rem;margin-left:3.25rem}.tui-space_horizontal-12.tui-space_horizontal-12{margin-right:3rem;margin-left:3rem}.tui-space_horizontal-11.tui-space_horizontal-11{margin-right:2.75rem;margin-left:2.75rem}.tui-space_horizontal-10.tui-space_horizontal-10{margin-right:2.5rem;margin-left:2.5rem}.tui-space_horizontal-9.tui-space_horizontal-9{margin-right:2.25rem;margin-left:2.25rem}.tui-space_horizontal-8.tui-space_horizontal-8{margin-right:2rem;margin-left:2rem}.tui-space_horizontal-7.tui-space_horizontal-7{margin-right:1.75rem;margin-left:1.75rem}.tui-space_horizontal-6.tui-space_horizontal-6{margin-right:1.5rem;margin-left:1.5rem}.tui-space_horizontal-5.tui-space_horizontal-5{margin-right:1.25rem;margin-left:1.25rem}.tui-space_horizontal-4.tui-space_horizontal-4{margin-right:1rem;margin-left:1rem}.tui-space_horizontal-3.tui-space_horizontal-3{margin-right:.75rem;margin-left:.75rem}.tui-space_horizontal-2.tui-space_horizontal-2{margin-right:.5rem;margin-left:.5rem}.tui-space_horizontal-1.tui-space_horizontal-1{margin-right:.25rem;margin-left:.25rem}.tui-space_horizontal-0.tui-space_horizontal-0{margin-right:0rem;margin-left:0rem}.tui-space_auto{margin-left:auto;margin-right:auto}.tui-table{inline-size:100%}.tui-table_layout_fixed{table-layout:fixed}.tui-table__tr{transition-property:background;transition-duration:var(--tui-duration, .3s);transition-timing-function:ease-in-out;outline:none}.tui-table__tr:not(.tui-table__tr_hover_disabled):hover{background:var(--tui-background-base-alt)}.tui-table__tr:not(.tui-table__tr_border_none){border-block-end:1px solid var(--tui-border-normal)}.tui-table__tr_border_top{border-block-start:1px solid var(--tui-border-normal)}.tui-table__tr_cursor_pointer{cursor:pointer}.tui-table__th{white-space:nowrap;overflow:hidden;text-overflow:ellipsis;font:var(--tui-font-text-s);padding:.5rem 1rem;vertical-align:middle;block-size:2.5rem;color:var(--tui-text-secondary);background:inherit}.tui-table__th_font-size_l,.tui-table_font-size_l .tui-table__th{font:var(--tui-font-text-m)}.tui-table__td{font:var(--tui-font-text-m);padding:1rem 1rem .875rem;vertical-align:top;overflow-wrap:break-word;block-size:3.4375rem;color:var(--tui-text-primary);background:inherit}.tui-table__td_size_l,.tui-table_size_l .tui-table__td{block-size:4.9375rem}.tui-table__td_font-size_l,.tui-table_font-size_l .tui-table__td{font:var(--tui-font-text-l)}.tui-table__td_font-size_s,.tui-table_font-size_s .tui-table__td{font:var(--tui-font-text-s)}.tui-table__td_align_center{vertical-align:middle}.tui-table__td,.tui-table__th{box-sizing:border-box;text-align:start}.tui-table_size_l .tui-table__td:before,.tui-table_size_l .tui-table__th:before{inline-size:1rem;border-top-left-radius:1rem;border-bottom-left-radius:1rem}.tui-table__td_first:before,.tui-table__th_first:before,.tui-table__td_last:before,.tui-table__th_last:before{content:"";position:absolute;top:0;inline-size:.75rem;block-size:100%;background:inherit;border-top-left-radius:.75rem;border-bottom-left-radius:.75rem}.tui-table__td_first,.tui-table__th_first{position:relative;padding-left:0;overflow:visible}.tui-table__td_first:before,.tui-table__th_first:before{right:100%}.tui-table__td_last,.tui-table__th_last{position:relative;padding-right:0;overflow:visible}.tui-table__td_last:before,.tui-table__th_last:before{left:100%;transform:scaleX(-1)}.tui-table__td_text_center,.tui-table__th_text_center{text-align:center}.tui-table__td_text_right,.tui-table__th_text_right{text-align:end}.tui-table__td_text_overflow,.tui-table__th_text_overflow{white-space:nowrap;overflow:hidden;text-overflow:ellipsis}.tui-table__subtext{font:var(--tui-font-text-s);margin:.25rem 0 0;color:var(--tui-text-tertiary)}.tui-table__sort{appearance:none;padding:0;border:0;background:none;font:inherit;line-height:inherit;text-decoration:none;transition-property:color;transition-duration:var(--tui-duration, .3s);transition-timing-function:ease-in-out;position:relative;display:inline-flex;align-items:center;outline:none;cursor:pointer}.tui-table__sort:hover{color:var(--tui-text-primary)}.tui-table__sort_active{color:var(--tui-text-action)}.tui-table__sort_active:hover{color:var(--tui-text-action-hover)}.tui-table__sort-icon{position:absolute;top:50%;transform:translateY(-50%);left:100%;margin-left:.125rem;inline-size:1rem;block-size:1rem;flex-shrink:0;opacity:0}.tui-table__sort_active .tui-table__sort-icon,.tui-table__sort:hover .tui-table__sort-icon{transition-property:transform;transition-duration:var(--tui-duration, .3s);transition-timing-function:ease-in-out;opacity:1}.tui-table__sort_active.tui-table__sort_up .tui-table__sort-icon{transform:rotate(180deg) translateY(50%)}.tui-text_h1{font:var(--tui-font-heading-1)}.tui-text_h2{font:var(--tui-font-heading-2)}.tui-text_h3{font:var(--tui-font-heading-3)}.tui-text_h4{font:var(--tui-font-heading-4)}.tui-text_h5{font:var(--tui-font-heading-5)}.tui-text_h6{font:var(--tui-font-heading-6)}.tui-text_body-xl{font:var(--tui-font-text-xl)}.tui-text_body-l{font:var(--tui-font-text-l)}.tui-text_body-l-2{font:var(--tui-font-text-ui-l)}.tui-text_body-m{font:var(--tui-font-text-m)}.tui-text_body-m-2{font:var(--tui-font-text-ui-m)}.tui-text_body-s{font:var(--tui-font-text-s)}.tui-text_body-s-2{font:var(--tui-font-text-ui-s)}.tui-text_body-xs{font:var(--tui-font-text-xs)}.tui-text_bold{font-weight:700}:root{--tui-font-heading: "Manrope", -apple-system, "BlinkMacSystemFont", system-ui, "Roboto", "Segoe UI", "Helvetica Neue", sans-serif;--tui-font-text: "Manrope", -apple-system, "BlinkMacSystemFont", system-ui, "Roboto", "Segoe UI", "Helvetica Neue", sans-serif;--tui-font-offset: 0rem;--tui-font-heading-1: bold calc(var(--tui-font-offset) + 3.125rem) / 3.5rem var(--tui-font-heading);--tui-font-heading-2: bold calc(var(--tui-font-offset) + 2.75rem) / 3rem var(--tui-font-heading);--tui-font-heading-3: bold calc(var(--tui-font-offset) + 2.25rem) / 2.5rem var(--tui-font-heading);--tui-font-heading-4: bold calc(var(--tui-font-offset) + 1.75rem) / 2rem var(--tui-font-heading);--tui-font-heading-5: bold calc(var(--tui-font-offset) + 1.5rem) / 1.75rem var(--tui-font-heading);--tui-font-heading-6: bold calc(var(--tui-font-offset) + 1.25rem) / 1.5rem var(--tui-font-heading);--tui-font-text-xl: normal calc(var(--tui-font-offset) + 1.1875rem) / 1.75rem var(--tui-font-text);--tui-font-text-l: normal calc(var(--tui-font-offset) + 1.0625rem) / 1.75rem var(--tui-font-text);--tui-font-text-m: normal calc(var(--tui-font-offset) + 1rem) / 1.5rem var(--tui-font-text);--tui-font-text-s: normal calc(var(--tui-font-offset) + .8125rem) / 1.25rem var(--tui-font-text);--tui-font-text-xs: normal calc(var(--tui-font-offset) + .6875rem) / 1rem var(--tui-font-text);--tui-font-text-ui-l: normal calc(var(--tui-font-offset) + 1.0625rem) / 1.5rem var(--tui-font-text);--tui-font-text-ui-m: normal calc(var(--tui-font-offset) + 1rem) / 1.25rem var(--tui-font-text);--tui-font-text-ui-s: normal calc(var(--tui-font-offset) + .8125rem) / 1rem var(--tui-font-text);--tui-font-text-ui-xs: normal calc(var(--tui-font-offset) + .6875rem) / .8125rem var(--tui-font-text);--tui-radius-xs: .25rem;--tui-radius-s: .5rem;--tui-radius-m: .625rem;--tui-radius-l: .75rem;--tui-radius-xl: 1.5rem;--tui-height-xs: 1.5rem;--tui-height-s: 2rem;--tui-height-m: 2.75rem;--tui-height-l: 3.5rem;--tui-padding-s: .625rem;--tui-padding-m: .75rem;--tui-padding-l: 1rem;--tui-duration: .3s;--tui-disabled-opacity: .56}@media screen{[tuiTheme=dark]{color-scheme:dark;--tui-background-base: #222;--tui-background-base-alt: #333;--tui-background-neutral-1: rgba(255, 255, 255, .08);--tui-background-neutral-1-hover: rgba(255, 255, 255, .16);--tui-background-neutral-1-pressed: rgba(255, 255, 255, .24);--tui-background-neutral-2: rgba(255, 255, 255, .24);--tui-background-neutral-2-hover: rgba(255, 255, 255, .32);--tui-background-neutral-2-pressed: rgba(255, 255, 255, .4);--tui-background-accent-opposite: #fff;--tui-background-accent-opposite-hover: #f6f6f6;--tui-background-accent-opposite-pressed: #ededed;--tui-background-elevation-1: #292929;--tui-background-elevation-2: #2f2f2f;--tui-background-elevation-3: #373737;--tui-service-autofill-background: #554a2a;--tui-border-normal: rgba(255, 255, 255, .14);--tui-border-hover: rgba(255, 255, 255, .6);--tui-border-focus: rgba(255, 255, 255, .64);--tui-status-negative: #ff8c67;--tui-status-negative-pale: rgba(244, 87, 37, .32);--tui-status-negative-pale-hover: rgba(244, 87, 37, .4);--tui-status-positive: #4ac99b;--tui-status-positive-pale: rgba(74, 201, 155, .32);--tui-status-positive-pale-hover: rgba(74, 201, 155, .4);--tui-status-warning: #ffc700;--tui-status-warning-pale: rgba(255, 199, 0, .32);--tui-status-warning-pale-hover: rgba(255, 199, 0, .4);--tui-status-info: #70b6f6;--tui-status-info-pale: rgba(112, 182, 246, .32);--tui-status-info-pale-hover: rgba(112, 182, 246, .4);--tui-status-neutral: #959ba4;--tui-text-primary: #ffffff;--tui-text-secondary: rgba(255, 255, 255, .72);--tui-text-tertiary: rgba(255, 255, 255, .6);--tui-text-action: #6788ff;--tui-text-action-hover: #526ed3;--tui-text-positive: #44c596;--tui-text-positive-hover: #3aa981;--tui-text-negative: #ff8c67;--tui-text-negative-hover: #bb593a}[tuiTheme=light]{color-scheme:light}:root,[tuiTheme=light]{--tui-background-base: #fff;--tui-background-base-alt: #f6f6f6;--tui-background-neutral-1: rgba(0, 0, 0, .04);--tui-background-neutral-1-hover: rgba(0, 0, 0, .08);--tui-background-neutral-1-pressed: rgba(0, 0, 0, .12);--tui-background-neutral-2: rgba(0, 0, 0, .08);--tui-background-neutral-2-hover: rgba(0, 0, 0, .1);--tui-background-neutral-2-pressed: rgba(0, 0, 0, .14);--tui-background-accent-1: #526ed3;--tui-background-accent-1-hover: #6c86e2;--tui-background-accent-1-pressed: #314692;--tui-background-accent-2: #ff7043;--tui-background-accent-2-hover: #ff9a94;--tui-background-accent-2-pressed: #e7716a;--tui-background-accent-opposite: #000;--tui-background-accent-opposite-hover: #333;--tui-background-accent-opposite-pressed: #808080;--tui-background-elevation-1: #fff;--tui-background-elevation-2: #fff;--tui-background-elevation-3: #fff;--tui-service-autofill-background: #fff5c0;--tui-service-selection-background: rgba(112, 182, 246, .12);--tui-service-backdrop: rgba(0, 0, 0, .75);--tui-border-normal: rgba(0, 0, 0, .1);--tui-border-hover: rgba(0, 0, 0, .16);--tui-border-focus: rgba(51, 51, 51, .64);--tui-status-negative: #f45725;--tui-status-negative-pale: rgba(244, 87, 37, .12);--tui-status-negative-pale-hover: rgba(244, 87, 37, .24);--tui-status-positive: #4ac99b;--tui-status-positive-pale: rgba(74, 201, 155, .12);--tui-status-positive-pale-hover: rgba(74, 201, 155, .24);--tui-status-warning: #ffc700;--tui-status-warning-pale: rgba(255, 199, 0, .12);--tui-status-warning-pale-hover: rgba(255, 199, 0, .24);--tui-status-info: #70b6f6;--tui-status-info-pale: rgba(112, 182, 246, .12);--tui-status-info-pale-hover: rgba(112, 182, 246, .24);--tui-status-neutral: #79818c;--tui-text-primary: #1b1f3b;--tui-text-secondary: rgba(27, 31, 59, .65);--tui-text-tertiary: rgba(27, 31, 59, .4);--tui-text-primary-on-accent-1: #fff;--tui-text-primary-on-accent-2: #fff;--tui-text-action: #4c66c3;--tui-text-action-hover: #6c86e2;--tui-text-positive: #3aa981;--tui-text-positive-hover: #7ac5aa;--tui-text-negative: #dd4c1e;--tui-text-negative-hover: #e38163;--tui-chart-categorical-00: var(--tui-background-accent-1);--tui-chart-categorical-01: #ea97c4;--tui-chart-categorical-02: #a0c5df;--tui-chart-categorical-03: #fee797;--tui-chart-categorical-04: #b0b0b0;--tui-chart-categorical-05: #e29398;--tui-chart-categorical-06: #b8474e;--tui-chart-categorical-07: #fcc068;--tui-chart-categorical-08: #ff8a00;--tui-chart-categorical-09: #dab3f9;--tui-chart-categorical-10: #7b439e;--tui-chart-categorical-11: #8dda71;--tui-chart-categorical-12: #fcbb14;--tui-chart-categorical-13: #a8cef1;--tui-chart-categorical-14: #bd65a4;--tui-chart-categorical-15: #7fd7cc;--tui-chart-categorical-16: #2fad96;--tui-chart-categorical-17: #d4aca2;--tui-chart-categorical-18: #9d6f64;--tui-chart-categorical-19: #d2e9a2;--tui-chart-categorical-20: #aadc42;--tui-chart-categorical-21: #3682db;--tui-chart-categorical-22: #34b41f;--tui-shadow-small: 0 .25rem 1.25rem rgba(0, 0, 0, .1);--tui-shadow-small-hover: 0 1rem 2.5rem rgba(0, 0, 0, .14);--tui-shadow-medium: 0 .375rem 2rem rgba(0, 0, 0, .12);--tui-shadow-medium-hover: 0 1.25rem 4rem rgba(0, 0, 0, .18);--tui-shadow-popup: 0 1.25rem 3rem rgba(0, 0, 0, .2)}}@media print{:root,[tuiTheme]{color-scheme:light;--tui-background-base: #fff;--tui-background-base-alt: #f6f6f6;--tui-background-neutral-1: rgba(0, 0, 0, .04);--tui-background-neutral-1-hover: rgba(0, 0, 0, .08);--tui-background-neutral-1-pressed: rgba(0, 0, 0, .12);--tui-background-neutral-2: rgba(0, 0, 0, .08);--tui-background-neutral-2-hover: rgba(0, 0, 0, .1);--tui-background-neutral-2-pressed: rgba(0, 0, 0, .14);--tui-background-accent-1: #526ed3;--tui-background-accent-1-hover: #6c86e2;--tui-background-accent-1-pressed: #314692;--tui-background-accent-2: #ff7043;--tui-background-accent-2-hover: #ff9a94;--tui-background-accent-2-pressed: #e7716a;--tui-background-accent-opposite: #000;--tui-background-accent-opposite-hover: #333;--tui-background-accent-opposite-pressed: #808080;--tui-background-elevation-1: #fff;--tui-background-elevation-2: #fff;--tui-background-elevation-3: #fff;--tui-service-autofill-background: #fff5c0;--tui-service-selection-background: rgba(112, 182, 246, .12);--tui-service-backdrop: rgba(0, 0, 0, .75);--tui-border-normal: rgba(0, 0, 0, .1);--tui-border-hover: rgba(0, 0, 0, .16);--tui-border-focus: rgba(51, 51, 51, .64);--tui-status-negative: #f45725;--tui-status-negative-pale: rgba(244, 87, 37, .12);--tui-status-negative-pale-hover: rgba(244, 87, 37, .24);--tui-status-positive: #4ac99b;--tui-status-positive-pale: rgba(74, 201, 155, .12);--tui-status-positive-pale-hover: rgba(74, 201, 155, .24);--tui-status-warning: #ffc700;--tui-status-warning-pale: rgba(255, 199, 0, .12);--tui-status-warning-pale-hover: rgba(255, 199, 0, .24);--tui-status-info: #70b6f6;--tui-status-info-pale: rgba(112, 182, 246, .12);--tui-status-info-pale-hover: rgba(112, 182, 246, .24);--tui-status-neutral: #79818c;--tui-text-primary: #1b1f3b;--tui-text-secondary: rgba(27, 31, 59, .65);--tui-text-tertiary: rgba(27, 31, 59, .4);--tui-text-primary-on-accent-1: #fff;--tui-text-primary-on-accent-2: #fff;--tui-text-action: #4c66c3;--tui-text-action-hover: #6c86e2;--tui-text-positive: #3aa981;--tui-text-positive-hover: #7ac5aa;--tui-text-negative: #dd4c1e;--tui-text-negative-hover: #e38163;--tui-chart-categorical-00: var(--tui-background-accent-1);--tui-chart-categorical-01: #ea97c4;--tui-chart-categorical-02: #a0c5df;--tui-chart-categorical-03: #fee797;--tui-chart-categorical-04: #b0b0b0;--tui-chart-categorical-05: #e29398;--tui-chart-categorical-06: #b8474e;--tui-chart-categorical-07: #fcc068;--tui-chart-categorical-08: #ff8a00;--tui-chart-categorical-09: #dab3f9;--tui-chart-categorical-10: #7b439e;--tui-chart-categorical-11: #8dda71;--tui-chart-categorical-12: #fcbb14;--tui-chart-categorical-13: #a8cef1;--tui-chart-categorical-14: #bd65a4;--tui-chart-categorical-15: #7fd7cc;--tui-chart-categorical-16: #2fad96;--tui-chart-categorical-17: #d4aca2;--tui-chart-categorical-18: #9d6f64;--tui-chart-categorical-19: #d2e9a2;--tui-chart-categorical-20: #aadc42;--tui-chart-categorical-21: #3682db;--tui-chart-categorical-22: #34b41f;--tui-shadow-small: 0 .25rem 1.25rem rgba(0, 0, 0, .1);--tui-shadow-small-hover: 0 1rem 2.5rem rgba(0, 0, 0, .14);--tui-shadow-medium: 0 .375rem 2rem rgba(0, 0, 0, .12);--tui-shadow-medium-hover: 0 1.25rem 4rem rgba(0, 0, 0, .18);--tui-shadow-popup: 0 1.25rem 3rem rgba(0, 0, 0, .2)}}[tuiAppearance][data-appearance=accent]{background:var(--tui-background-accent-2);color:var(--tui-text-primary-on-accent-2)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=accent]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){background:var(--tui-background-accent-2-hover)}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=accent]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){background:var(--tui-background-accent-2-hover)}}[tuiAppearance][data-appearance=accent][data-state=hover]{background:var(--tui-background-accent-2-hover)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=accent][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=accent][tuiWrapper][data-state=hover]{background:var(--tui-background-accent-2-hover)}}[tuiAppearance][data-appearance=accent]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){background:var(--tui-background-accent-2-pressed)}[tuiAppearance][data-appearance=accent]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){background:var(--tui-background-accent-2-pressed)}[tuiAppearance][data-appearance=accent][data-state=active]{background:var(--tui-background-accent-2-pressed)}[tuiAppearance][data-appearance=accent][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=accent][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=accent][tuiWrapper][data-state=active]:hover{background:var(--tui-background-accent-2-pressed)}[tuiAppearance][data-appearance=link]{color:var(--tui-text-action);background:transparent}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=link]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){color:var(--tui-text-action-hover)}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=link]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){color:var(--tui-text-action-hover)}}[tuiAppearance][data-appearance=link][data-state=hover]{color:var(--tui-text-action-hover)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=link][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=link][tuiWrapper][data-state=hover]{color:var(--tui-text-action-hover)}}[tuiAppearance][data-appearance=link]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){color:var(--tui-text-action-hover)}[tuiAppearance][data-appearance=link]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){color:var(--tui-text-action-hover)}[tuiAppearance][data-appearance=link][data-state=active]{color:var(--tui-text-action-hover)}[tuiAppearance][data-appearance=link][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=link][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=link][tuiWrapper][data-state=active]:hover{color:var(--tui-text-action-hover)}[tuiAppearance][data-appearance=action]{color:var(--tui-text-action);background:transparent}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=action]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){color:var(--tui-text-action-hover)}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=action]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){color:var(--tui-text-action-hover)}}[tuiAppearance][data-appearance=action][data-state=hover]{color:var(--tui-text-action-hover)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=action][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=action][tuiWrapper][data-state=hover]{color:var(--tui-text-action-hover)}}[tuiAppearance][data-appearance=action]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){color:var(--tui-text-action-hover)}[tuiAppearance][data-appearance=action]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){color:var(--tui-text-action-hover)}[tuiAppearance][data-appearance=action][data-state=active]{color:var(--tui-text-action-hover)}[tuiAppearance][data-appearance=action][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=action][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=action][tuiWrapper][data-state=active]:hover{color:var(--tui-text-action-hover)}[tuiAppearance][data-appearance=action-destructive]{color:var(--tui-text-negative);background:transparent}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=action-destructive]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){color:var(--tui-text-negative-hover)}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=action-destructive]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){color:var(--tui-text-negative-hover)}}[tuiAppearance][data-appearance=action-destructive][data-state=hover]{color:var(--tui-text-negative-hover)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=action-destructive][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=action-destructive][tuiWrapper][data-state=hover]{color:var(--tui-text-negative-hover)}}[tuiAppearance][data-appearance=action-destructive]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){color:var(--tui-text-negative-hover)}[tuiAppearance][data-appearance=action-destructive]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){color:var(--tui-text-negative-hover)}[tuiAppearance][data-appearance=action-destructive][data-state=active]{color:var(--tui-text-negative-hover)}[tuiAppearance][data-appearance=action-destructive][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=action-destructive][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=action-destructive][tuiWrapper][data-state=active]:hover{color:var(--tui-text-negative-hover)}[tuiAppearance][data-appearance=action-grayscale]{color:var(--tui-text-secondary);background:transparent}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=action-grayscale]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){color:var(--tui-text-primary)}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=action-grayscale]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){color:var(--tui-text-primary)}}[tuiAppearance][data-appearance=action-grayscale][data-state=hover]{color:var(--tui-text-primary)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=action-grayscale][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=action-grayscale][tuiWrapper][data-state=hover]{color:var(--tui-text-primary)}}[tuiAppearance][data-appearance=action-grayscale]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){color:var(--tui-text-primary)}[tuiAppearance][data-appearance=action-grayscale]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){color:var(--tui-text-primary)}[tuiAppearance][data-appearance=action-grayscale][data-state=active]{color:var(--tui-text-primary)}[tuiAppearance][data-appearance=action-grayscale][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=action-grayscale][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=action-grayscale][tuiWrapper][data-state=active]:hover{color:var(--tui-text-primary)}[tuiAppearance][data-appearance=flat],[tuiAppearance][data-appearance=flat-destructive],[tuiAppearance][data-appearance=flat-grayscale]{color:var(--tui-text-action)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=flat]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=flat-destructive]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=flat-grayscale]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){background:var(--tui-background-neutral-1-hover)}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=flat]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=flat-destructive]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=flat-grayscale]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){background:var(--tui-background-neutral-1-hover)}}[tuiAppearance][data-appearance=flat][data-state=hover],[tuiAppearance][data-appearance=flat-destructive][data-state=hover],[tuiAppearance][data-appearance=flat-grayscale][data-state=hover]{background:var(--tui-background-neutral-1-hover)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=flat][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=flat-destructive][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=flat-grayscale][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=flat][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=flat-destructive][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=flat-grayscale][tuiWrapper][data-state=hover]{background:var(--tui-background-neutral-1-hover)}}[tuiAppearance][data-appearance=flat]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=flat-destructive]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=flat-grayscale]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){background:var(--tui-background-neutral-1-pressed)}[tuiAppearance][data-appearance=flat]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=flat-destructive]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=flat-grayscale]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){background:var(--tui-background-neutral-1-pressed)}[tuiAppearance][data-appearance=flat][data-state=active],[tuiAppearance][data-appearance=flat-destructive][data-state=active],[tuiAppearance][data-appearance=flat-grayscale][data-state=active]{background:var(--tui-background-neutral-1-pressed)}[tuiAppearance][data-appearance=flat][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=flat-destructive][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=flat-grayscale][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=flat][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=flat-destructive][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=flat-grayscale][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=flat][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=flat-destructive][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=flat-grayscale][tuiWrapper][data-state=active]:hover{background:var(--tui-background-neutral-1-pressed)}[tuiAppearance][data-appearance=flat-destructive]{color:var(--tui-text-negative)}[tuiAppearance][data-appearance=flat-grayscale]{color:var(--tui-text-primary)}[tuiAppearance][data-appearance=floating]{background:var(--tui-background-elevation-2);color:var(--tui-text-primary);box-shadow:0 .25rem 1.25rem #0000001a}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=floating]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){box-shadow:0 .875rem 2.625rem #00000024}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=floating]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){box-shadow:0 .875rem 2.625rem #00000024}}[tuiAppearance][data-appearance=floating][data-state=hover]{box-shadow:0 .875rem 2.625rem #00000024}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=floating][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=floating][tuiWrapper][data-state=hover]{box-shadow:0 .875rem 2.625rem #00000024}}[tuiAppearance][data-appearance=floating]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){background:var(--tui-background-base-alt);box-shadow:0 .25rem 1.25rem #0000001a}[tuiAppearance][data-appearance=floating]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){background:var(--tui-background-base-alt);box-shadow:0 .25rem 1.25rem #0000001a}[tuiAppearance][data-appearance=floating][data-state=active]{background:var(--tui-background-base-alt);box-shadow:0 .25rem 1.25rem #0000001a}[tuiAppearance][data-appearance=floating][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=floating][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=floating][tuiWrapper][data-state=active]:hover{background:var(--tui-background-base-alt);box-shadow:0 .25rem 1.25rem #0000001a}[tuiAppearance][data-appearance=glass]{background:#0006;color:#fff;-webkit-backdrop-filter:blur(1rem);backdrop-filter:blur(1rem);--tui-border-focus: rgba(255, 255, 255, .64)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=glass]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){background:#0000007a}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=glass]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){background:#0000007a}}[tuiAppearance][data-appearance=glass][data-state=hover]{background:#0000007a}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=glass][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=glass][tuiWrapper][data-state=hover]{background:#0000007a}}[tuiAppearance][data-appearance=glass]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){background:#0009}[tuiAppearance][data-appearance=glass]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){background:#0009}[tuiAppearance][data-appearance=glass][data-state=active]{background:#0009}[tuiAppearance][data-appearance=glass][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=glass][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=glass][tuiWrapper][data-state=active]:hover{background:#0009}[tuiTheme=dark] [tuiAppearance][data-appearance=glass],[tuiTheme=dark][tuiAppearance][data-appearance=glass]{background:#ffffff4d}@media (hover: hover) and (pointer: fine){[tuiTheme=dark] [tuiAppearance][data-appearance=glass]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiTheme=dark][tuiAppearance][data-appearance=glass]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){background:#fff6}}@media (hover: hover) and (pointer: fine){[tuiTheme=dark] [tuiAppearance][data-appearance=glass]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiTheme=dark][tuiAppearance][data-appearance=glass]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){background:#fff6}}[tuiTheme=dark] [tuiAppearance][data-appearance=glass][data-state=hover],[tuiTheme=dark][tuiAppearance][data-appearance=glass][data-state=hover]{background:#fff6}@media (hover: hover) and (pointer: fine){[tuiTheme=dark] [tuiAppearance][data-appearance=glass][tuiWrapper]:hover:not(._no-hover),[tuiTheme=dark][tuiAppearance][data-appearance=glass][tuiWrapper]:hover:not(._no-hover),[tuiTheme=dark] [tuiAppearance][data-appearance=glass][tuiWrapper][data-state=hover],[tuiTheme=dark][tuiAppearance][data-appearance=glass][tuiWrapper][data-state=hover]{background:#fff6}}[tuiTheme=dark] [tuiAppearance][data-appearance=glass]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiTheme=dark][tuiAppearance][data-appearance=glass]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){background:#ffffff80}[tuiTheme=dark] [tuiAppearance][data-appearance=glass]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiTheme=dark][tuiAppearance][data-appearance=glass]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){background:#ffffff80}[tuiTheme=dark] [tuiAppearance][data-appearance=glass][data-state=active],[tuiTheme=dark][tuiAppearance][data-appearance=glass][data-state=active]{background:#ffffff80}[tuiTheme=dark] [tuiAppearance][data-appearance=glass][tuiWrapper]:active:not(._no-active),[tuiTheme=dark][tuiAppearance][data-appearance=glass][tuiWrapper]:active:not(._no-active),[tuiTheme=dark] [tuiAppearance][data-appearance=glass][tuiWrapper][data-state=active],[tuiTheme=dark][tuiAppearance][data-appearance=glass][tuiWrapper][data-state=active],[tuiTheme=dark] [tuiAppearance][data-appearance=glass][tuiWrapper][data-state=active]:hover,[tuiTheme=dark][tuiAppearance][data-appearance=glass][tuiWrapper][data-state=active]:hover{background:#ffffff80}[tuiAppearance][data-appearance=opposite]{--tui-border-focus: #979797;background:var(--tui-background-accent-opposite);color:var(--tui-background-base)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=opposite]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){background:var(--tui-background-accent-opposite-hover)}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=opposite]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){background:var(--tui-background-accent-opposite-hover)}}[tuiAppearance][data-appearance=opposite][data-state=hover]{background:var(--tui-background-accent-opposite-hover)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=opposite][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=opposite][tuiWrapper][data-state=hover]{background:var(--tui-background-accent-opposite-hover)}}[tuiAppearance][data-appearance=opposite]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){background:var(--tui-background-accent-opposite-pressed)}[tuiAppearance][data-appearance=opposite]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){background:var(--tui-background-accent-opposite-pressed)}[tuiAppearance][data-appearance=opposite][data-state=active]{background:var(--tui-background-accent-opposite-pressed)}[tuiAppearance][data-appearance=opposite][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=opposite][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=opposite][tuiWrapper][data-state=active]:hover{background:var(--tui-background-accent-opposite-pressed)}[tuiAppearance][data-appearance=outline],[tuiAppearance][data-appearance=outline-destructive],[tuiAppearance][data-appearance=outline-grayscale],[tuiAppearance][data-appearance=whiteblock]{--t-bs: var(--tui-border-normal);color:var(--tui-text-action);box-shadow:inset 0 0 0 1px var(--t-bs)}[tuiAppearance][data-appearance=outline]:checked:not([data-mode]),[tuiAppearance][data-appearance=outline-destructive]:checked:not([data-mode]),[tuiAppearance][data-appearance=outline-grayscale]:checked:not([data-mode]),[tuiAppearance][data-appearance=whiteblock]:checked:not([data-mode]),[tuiAppearance][data-appearance=outline][data-mode~=checked],[tuiAppearance][data-appearance=outline-destructive][data-mode~=checked],[tuiAppearance][data-appearance=outline-grayscale][data-mode~=checked],[tuiAppearance][data-appearance=whiteblock][data-mode~=checked]{--t-bs: var(--tui-background-accent-1);box-shadow:inset 0 0 0 2px var(--t-bs)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=outline]:checked:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline-destructive]:checked:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline-grayscale]:checked:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=whiteblock]:checked:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline][data-mode~=checked]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline-destructive][data-mode~=checked]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline-grayscale][data-mode~=checked]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=whiteblock][data-mode~=checked]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){--t-bs: var(--tui-background-accent-1-hover)}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=outline]:checked:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline-destructive]:checked:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline-grayscale]:checked:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=whiteblock]:checked:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline][data-mode~=checked]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline-destructive][data-mode~=checked]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline-grayscale][data-mode~=checked]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=whiteblock][data-mode~=checked]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){--t-bs: var(--tui-background-accent-1-hover)}}[tuiAppearance][data-appearance=outline]:checked:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=outline-destructive]:checked:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=outline-grayscale]:checked:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=whiteblock]:checked:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=outline][data-mode~=checked][data-state=hover],[tuiAppearance][data-appearance=outline-destructive][data-mode~=checked][data-state=hover],[tuiAppearance][data-appearance=outline-grayscale][data-mode~=checked][data-state=hover],[tuiAppearance][data-appearance=whiteblock][data-mode~=checked][data-state=hover]{--t-bs: var(--tui-background-accent-1-hover)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=outline]:checked:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=outline-destructive]:checked:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=outline-grayscale]:checked:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=whiteblock]:checked:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=outline][data-mode~=checked][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=outline-destructive][data-mode~=checked][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=outline-grayscale][data-mode~=checked][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=whiteblock][data-mode~=checked][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=outline]:checked:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=outline-destructive]:checked:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=outline-grayscale]:checked:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=whiteblock]:checked:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=outline][data-mode~=checked][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=outline-destructive][data-mode~=checked][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=outline-grayscale][data-mode~=checked][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=whiteblock][data-mode~=checked][tuiWrapper][data-state=hover]{--t-bs: var(--tui-background-accent-1-hover)}}[tuiAppearance][data-appearance=outline]:checked:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline-destructive]:checked:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline-grayscale]:checked:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=whiteblock]:checked:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline][data-mode~=checked]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline-destructive][data-mode~=checked]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline-grayscale][data-mode~=checked]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=whiteblock][data-mode~=checked]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){--t-bs: var(--tui-background-accent-1-pressed)}[tuiAppearance][data-appearance=outline]:checked:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline-destructive]:checked:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline-grayscale]:checked:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=whiteblock]:checked:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline][data-mode~=checked]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline-destructive][data-mode~=checked]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline-grayscale][data-mode~=checked]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=whiteblock][data-mode~=checked]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){--t-bs: var(--tui-background-accent-1-pressed)}[tuiAppearance][data-appearance=outline]:checked:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=outline-destructive]:checked:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=outline-grayscale]:checked:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=whiteblock]:checked:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=outline][data-mode~=checked][data-state=active],[tuiAppearance][data-appearance=outline-destructive][data-mode~=checked][data-state=active],[tuiAppearance][data-appearance=outline-grayscale][data-mode~=checked][data-state=active],[tuiAppearance][data-appearance=whiteblock][data-mode~=checked][data-state=active]{--t-bs: var(--tui-background-accent-1-pressed)}[tuiAppearance][data-appearance=outline]:checked:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=outline-destructive]:checked:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=outline-grayscale]:checked:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=whiteblock]:checked:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=outline][data-mode~=checked][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=outline-destructive][data-mode~=checked][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=outline-grayscale][data-mode~=checked][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=whiteblock][data-mode~=checked][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=outline]:checked:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=outline-destructive]:checked:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=outline-grayscale]:checked:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=whiteblock]:checked:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=outline][data-mode~=checked][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=outline-destructive][data-mode~=checked][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=outline-grayscale][data-mode~=checked][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=whiteblock][data-mode~=checked][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=outline]:checked:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=outline-destructive]:checked:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=outline-grayscale]:checked:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=whiteblock]:checked:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=outline][data-mode~=checked][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=outline-destructive][data-mode~=checked][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=outline-grayscale][data-mode~=checked][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=whiteblock][data-mode~=checked][tuiWrapper][data-state=active]:hover{--t-bs: var(--tui-background-accent-1-pressed)}[tuiAppearance][data-appearance=outline]:invalid:not([data-mode]),[tuiAppearance][data-appearance=outline-destructive]:invalid:not([data-mode]),[tuiAppearance][data-appearance=outline-grayscale]:invalid:not([data-mode]),[tuiAppearance][data-appearance=whiteblock]:invalid:not([data-mode]),[tuiAppearance][data-appearance=outline][data-mode~=invalid],[tuiAppearance][data-appearance=outline-destructive][data-mode~=invalid],[tuiAppearance][data-appearance=outline-grayscale][data-mode~=invalid],[tuiAppearance][data-appearance=whiteblock][data-mode~=invalid]{box-shadow:inset 0 0 0 1px var(--tui-status-negative-pale-hover)}[tuiAppearance][data-appearance=outline]:checked:invalid:not([data-mode]),[tuiAppearance][data-appearance=outline-destructive]:checked:invalid:not([data-mode]),[tuiAppearance][data-appearance=outline-grayscale]:checked:invalid:not([data-mode]),[tuiAppearance][data-appearance=whiteblock]:checked:invalid:not([data-mode]),[tuiAppearance][data-appearance=outline][data-mode~=checked][data-mode~=invalid],[tuiAppearance][data-appearance=outline-destructive][data-mode~=checked][data-mode~=invalid],[tuiAppearance][data-appearance=outline-grayscale][data-mode~=checked][data-mode~=invalid],[tuiAppearance][data-appearance=whiteblock][data-mode~=checked][data-mode~=invalid]{box-shadow:inset 0 0 0 2px var(--tui-status-negative)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=outline]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline-destructive]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline-grayscale]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=whiteblock]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){background:var(--tui-background-neutral-1);cursor:pointer;--t-bs: var(--tui-border-hover)}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=outline]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline-destructive]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline-grayscale]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=whiteblock]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){background:var(--tui-background-neutral-1);cursor:pointer;--t-bs: var(--tui-border-hover)}}[tuiAppearance][data-appearance=outline][data-state=hover],[tuiAppearance][data-appearance=outline-destructive][data-state=hover],[tuiAppearance][data-appearance=outline-grayscale][data-state=hover],[tuiAppearance][data-appearance=whiteblock][data-state=hover]{background:var(--tui-background-neutral-1);cursor:pointer;--t-bs: var(--tui-border-hover)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=outline][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=outline-destructive][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=outline-grayscale][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=whiteblock][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=outline][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=outline-destructive][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=outline-grayscale][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=whiteblock][tuiWrapper][data-state=hover]{background:var(--tui-background-neutral-1);cursor:pointer;--t-bs: var(--tui-border-hover)}}[tuiAppearance][data-appearance=outline]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline-destructive]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline-grayscale]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=whiteblock]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){background:var(--tui-background-neutral-1);--t-bs: var(--tui-border-hover)}[tuiAppearance][data-appearance=outline]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline-destructive]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=outline-grayscale]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=whiteblock]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){background:var(--tui-background-neutral-1);--t-bs: var(--tui-border-hover)}[tuiAppearance][data-appearance=outline][data-state=active],[tuiAppearance][data-appearance=outline-destructive][data-state=active],[tuiAppearance][data-appearance=outline-grayscale][data-state=active],[tuiAppearance][data-appearance=whiteblock][data-state=active]{background:var(--tui-background-neutral-1);--t-bs: var(--tui-border-hover)}[tuiAppearance][data-appearance=outline][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=outline-destructive][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=outline-grayscale][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=whiteblock][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=outline][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=outline-destructive][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=outline-grayscale][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=whiteblock][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=outline][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=outline-destructive][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=outline-grayscale][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=whiteblock][tuiWrapper][data-state=active]:hover{background:var(--tui-background-neutral-1);--t-bs: var(--tui-border-hover)}[tuiAppearance][data-appearance=outline-grayscale],[tuiAppearance][data-appearance=whiteblock]{color:var(--tui-text-primary)}[tuiAppearance][data-appearance=outline-destructive]{color:var(--tui-text-negative)}[tuiAppearance][data-appearance=icon],[tuiAppearance][data-appearance=outline-grayscale],[tuiAppearance][data-appearance=floating],[tuiAppearance][data-appearance=whiteblock]{color:var(--tui-text-primary)}[tuiAppearance][data-appearance=icon]:before,[tuiAppearance][data-appearance=outline-grayscale]:before,[tuiAppearance][data-appearance=floating]:before,[tuiAppearance][data-appearance=whiteblock]:before,[tuiAppearance][data-appearance=icon]:after,[tuiAppearance][data-appearance=outline-grayscale]:after,[tuiAppearance][data-appearance=floating]:after,[tuiAppearance][data-appearance=whiteblock]:after{transition-property:color,transform;transition-duration:var(--tui-duration, .3s);transition-timing-function:ease-in-out;color:var(--tui-text-tertiary)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=icon]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]):before,[tuiAppearance][data-appearance=outline-grayscale]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]):before,[tuiAppearance][data-appearance=floating]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]):before,[tuiAppearance][data-appearance=whiteblock]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]):before,[tuiAppearance][data-appearance=icon]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]):after,[tuiAppearance][data-appearance=outline-grayscale]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]):after,[tuiAppearance][data-appearance=floating]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]):after,[tuiAppearance][data-appearance=whiteblock]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]):after{color:var(--tui-text-secondary)}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=icon]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]):before,[tuiAppearance][data-appearance=outline-grayscale]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]):before,[tuiAppearance][data-appearance=floating]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]):before,[tuiAppearance][data-appearance=whiteblock]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]):before,[tuiAppearance][data-appearance=icon]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]):after,[tuiAppearance][data-appearance=outline-grayscale]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]):after,[tuiAppearance][data-appearance=floating]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]):after,[tuiAppearance][data-appearance=whiteblock]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]):after{color:var(--tui-text-secondary)}}[tuiAppearance][data-appearance=icon][data-state=hover]:before,[tuiAppearance][data-appearance=outline-grayscale][data-state=hover]:before,[tuiAppearance][data-appearance=floating][data-state=hover]:before,[tuiAppearance][data-appearance=whiteblock][data-state=hover]:before,[tuiAppearance][data-appearance=icon][data-state=hover]:after,[tuiAppearance][data-appearance=outline-grayscale][data-state=hover]:after,[tuiAppearance][data-appearance=floating][data-state=hover]:after,[tuiAppearance][data-appearance=whiteblock][data-state=hover]:after{color:var(--tui-text-secondary)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=icon][tuiWrapper]:hover:not(._no-hover):before,[tuiAppearance][data-appearance=outline-grayscale][tuiWrapper]:hover:not(._no-hover):before,[tuiAppearance][data-appearance=floating][tuiWrapper]:hover:not(._no-hover):before,[tuiAppearance][data-appearance=whiteblock][tuiWrapper]:hover:not(._no-hover):before,[tuiAppearance][data-appearance=icon][tuiWrapper][data-state=hover]:before,[tuiAppearance][data-appearance=outline-grayscale][tuiWrapper][data-state=hover]:before,[tuiAppearance][data-appearance=floating][tuiWrapper][data-state=hover]:before,[tuiAppearance][data-appearance=whiteblock][tuiWrapper][data-state=hover]:before,[tuiAppearance][data-appearance=icon][tuiWrapper]:hover:not(._no-hover):after,[tuiAppearance][data-appearance=outline-grayscale][tuiWrapper]:hover:not(._no-hover):after,[tuiAppearance][data-appearance=floating][tuiWrapper]:hover:not(._no-hover):after,[tuiAppearance][data-appearance=whiteblock][tuiWrapper]:hover:not(._no-hover):after,[tuiAppearance][data-appearance=icon][tuiWrapper][data-state=hover]:after,[tuiAppearance][data-appearance=outline-grayscale][tuiWrapper][data-state=hover]:after,[tuiAppearance][data-appearance=floating][tuiWrapper][data-state=hover]:after,[tuiAppearance][data-appearance=whiteblock][tuiWrapper][data-state=hover]:after{color:var(--tui-text-secondary)}}[tuiAppearance][data-appearance=icon]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]):before,[tuiAppearance][data-appearance=outline-grayscale]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]):before,[tuiAppearance][data-appearance=floating]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]):before,[tuiAppearance][data-appearance=whiteblock]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]):before,[tuiAppearance][data-appearance=icon]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]):after,[tuiAppearance][data-appearance=outline-grayscale]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]):after,[tuiAppearance][data-appearance=floating]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]):after,[tuiAppearance][data-appearance=whiteblock]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]):after{color:var(--tui-text-primary)}[tuiAppearance][data-appearance=icon]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]):before,[tuiAppearance][data-appearance=outline-grayscale]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]):before,[tuiAppearance][data-appearance=floating]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]):before,[tuiAppearance][data-appearance=whiteblock]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]):before,[tuiAppearance][data-appearance=icon]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]):after,[tuiAppearance][data-appearance=outline-grayscale]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]):after,[tuiAppearance][data-appearance=floating]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]):after,[tuiAppearance][data-appearance=whiteblock]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]):after{color:var(--tui-text-primary)}[tuiAppearance][data-appearance=icon][data-state=active]:before,[tuiAppearance][data-appearance=outline-grayscale][data-state=active]:before,[tuiAppearance][data-appearance=floating][data-state=active]:before,[tuiAppearance][data-appearance=whiteblock][data-state=active]:before,[tuiAppearance][data-appearance=icon][data-state=active]:after,[tuiAppearance][data-appearance=outline-grayscale][data-state=active]:after,[tuiAppearance][data-appearance=floating][data-state=active]:after,[tuiAppearance][data-appearance=whiteblock][data-state=active]:after{color:var(--tui-text-primary)}[tuiAppearance][data-appearance=icon][tuiWrapper]:active:not(._no-active):before,[tuiAppearance][data-appearance=outline-grayscale][tuiWrapper]:active:not(._no-active):before,[tuiAppearance][data-appearance=floating][tuiWrapper]:active:not(._no-active):before,[tuiAppearance][data-appearance=whiteblock][tuiWrapper]:active:not(._no-active):before,[tuiAppearance][data-appearance=icon][tuiWrapper][data-state=active]:before,[tuiAppearance][data-appearance=outline-grayscale][tuiWrapper][data-state=active]:before,[tuiAppearance][data-appearance=floating][tuiWrapper][data-state=active]:before,[tuiAppearance][data-appearance=whiteblock][tuiWrapper][data-state=active]:before,[tuiAppearance][data-appearance=icon][tuiWrapper][data-state=active]:hover:before,[tuiAppearance][data-appearance=outline-grayscale][tuiWrapper][data-state=active]:hover:before,[tuiAppearance][data-appearance=floating][tuiWrapper][data-state=active]:hover:before,[tuiAppearance][data-appearance=whiteblock][tuiWrapper][data-state=active]:hover:before,[tuiAppearance][data-appearance=icon][tuiWrapper]:active:not(._no-active):after,[tuiAppearance][data-appearance=outline-grayscale][tuiWrapper]:active:not(._no-active):after,[tuiAppearance][data-appearance=floating][tuiWrapper]:active:not(._no-active):after,[tuiAppearance][data-appearance=whiteblock][tuiWrapper]:active:not(._no-active):after,[tuiAppearance][data-appearance=icon][tuiWrapper][data-state=active]:after,[tuiAppearance][data-appearance=outline-grayscale][tuiWrapper][data-state=active]:after,[tuiAppearance][data-appearance=floating][tuiWrapper][data-state=active]:after,[tuiAppearance][data-appearance=whiteblock][tuiWrapper][data-state=active]:after,[tuiAppearance][data-appearance=icon][tuiWrapper][data-state=active]:hover:after,[tuiAppearance][data-appearance=outline-grayscale][tuiWrapper][data-state=active]:hover:after,[tuiAppearance][data-appearance=floating][tuiWrapper][data-state=active]:hover:after,[tuiAppearance][data-appearance=whiteblock][tuiWrapper][data-state=active]:hover:after{color:var(--tui-text-primary)}[tuiAppearance][data-appearance=primary]{--t-bg: var(--tui-background-accent-1);background:var(--t-bg);color:var(--tui-text-primary-on-accent-1)}[tuiAppearance][data-appearance=primary]:invalid:not([data-mode]),[tuiAppearance][data-appearance=primary][data-mode~=invalid]{background:var(--tui-status-negative)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=primary]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){--t-bg: var(--tui-background-accent-1-hover)}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=primary]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){--t-bg: var(--tui-background-accent-1-hover)}}[tuiAppearance][data-appearance=primary][data-state=hover]{--t-bg: var(--tui-background-accent-1-hover)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=primary][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=primary][tuiWrapper][data-state=hover]{--t-bg: var(--tui-background-accent-1-hover)}}[tuiAppearance][data-appearance=primary]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){--t-bg: var(--tui-background-accent-1-pressed)}[tuiAppearance][data-appearance=primary]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){--t-bg: var(--tui-background-accent-1-pressed)}[tuiAppearance][data-appearance=primary][data-state=active]{--t-bg: var(--tui-background-accent-1-pressed)}[tuiAppearance][data-appearance=primary][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=primary][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=primary][tuiWrapper][data-state=active]:hover{--t-bg: var(--tui-background-accent-1-pressed)}[tuiAppearance][data-appearance=primary-destructive]{color:#fff;background:var(--tui-status-negative)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=primary-destructive]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){filter:saturate(1) brightness(1.3)}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=primary-destructive]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){filter:saturate(1) brightness(1.3)}}[tuiAppearance][data-appearance=primary-destructive][data-state=hover]{filter:saturate(1) brightness(1.3)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=primary-destructive][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=primary-destructive][tuiWrapper][data-state=hover]{filter:saturate(1) brightness(1.3)}}[tuiAppearance][data-appearance=primary-destructive]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){filter:saturate(.8) brightness(1)}[tuiAppearance][data-appearance=primary-destructive]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){filter:saturate(.8) brightness(1)}[tuiAppearance][data-appearance=primary-destructive][data-state=active]{filter:saturate(.8) brightness(1)}[tuiAppearance][data-appearance=primary-destructive][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=primary-destructive][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=primary-destructive][tuiWrapper][data-state=active]:hover{filter:saturate(.8) brightness(1)}[tuiAppearance][data-appearance=primary-grayscale]{--tui-border-focus: #979797;background:var(--tui-background-accent-opposite);color:var(--tui-background-base)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=primary-grayscale]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){background:var(--tui-background-accent-opposite-hover)}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=primary-grayscale]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){background:var(--tui-background-accent-opposite-hover)}}[tuiAppearance][data-appearance=primary-grayscale][data-state=hover]{background:var(--tui-background-accent-opposite-hover)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=primary-grayscale][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=primary-grayscale][tuiWrapper][data-state=hover]{background:var(--tui-background-accent-opposite-hover)}}[tuiAppearance][data-appearance=primary-grayscale]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){background:var(--tui-background-accent-opposite-pressed)}[tuiAppearance][data-appearance=primary-grayscale]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){background:var(--tui-background-accent-opposite-pressed)}[tuiAppearance][data-appearance=primary-grayscale][data-state=active]{background:var(--tui-background-accent-opposite-pressed)}[tuiAppearance][data-appearance=primary-grayscale][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=primary-grayscale][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=primary-grayscale][tuiWrapper][data-state=active]:hover{background:var(--tui-background-accent-opposite-pressed)}[tuiAppearance][data-appearance=secondary],[tuiAppearance][data-appearance=secondary-destructive],[tuiAppearance][data-appearance=secondary-grayscale],[tuiAppearance][data-appearance=destructive]{background:var(--tui-background-neutral-1);color:var(--tui-text-action)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=secondary]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){background:var(--tui-background-neutral-1-hover)}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=secondary]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){background:var(--tui-background-neutral-1-hover)}}[tuiAppearance][data-appearance=secondary][data-state=hover],[tuiAppearance][data-appearance=secondary-destructive][data-state=hover],[tuiAppearance][data-appearance=secondary-grayscale][data-state=hover],[tuiAppearance][data-appearance=destructive][data-state=hover]{background:var(--tui-background-neutral-1-hover)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=secondary][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary-destructive][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary-grayscale][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=destructive][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary-destructive][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary-grayscale][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=destructive][tuiWrapper][data-state=hover]{background:var(--tui-background-neutral-1-hover)}}[tuiAppearance][data-appearance=secondary]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){background:var(--tui-background-neutral-1-pressed)}[tuiAppearance][data-appearance=secondary]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){background:var(--tui-background-neutral-1-pressed)}[tuiAppearance][data-appearance=secondary][data-state=active],[tuiAppearance][data-appearance=secondary-destructive][data-state=active],[tuiAppearance][data-appearance=secondary-grayscale][data-state=active],[tuiAppearance][data-appearance=destructive][data-state=active]{background:var(--tui-background-neutral-1-pressed)}[tuiAppearance][data-appearance=secondary][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary-destructive][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary-grayscale][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=destructive][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary-destructive][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary-grayscale][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=destructive][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary-destructive][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary-grayscale][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=destructive][tuiWrapper][data-state=active]:hover{background:var(--tui-background-neutral-1-pressed)}[tuiAppearance][data-appearance=secondary]:checked:not([data-mode]),[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode]),[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode]),[tuiAppearance][data-appearance=destructive]:checked:not([data-mode]),[tuiAppearance][data-appearance=secondary][data-mode~=checked],[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked],[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked],[tuiAppearance][data-appearance=destructive][data-mode~=checked],[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode]),[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode]),[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode]),[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode]){background:var(--tui-background-accent-1);color:var(--tui-text-primary-on-accent-1)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=secondary]:checked:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive]:checked:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][data-mode~=checked]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][data-mode~=checked]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){background:var(--tui-background-accent-1-hover)}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=secondary]:checked:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive]:checked:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][data-mode~=checked]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][data-mode~=checked]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){background:var(--tui-background-accent-1-hover)}}[tuiAppearance][data-appearance=secondary]:checked:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=destructive]:checked:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=secondary][data-mode~=checked][data-state=hover],[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked][data-state=hover],[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked][data-state=hover],[tuiAppearance][data-appearance=destructive][data-mode~=checked][data-state=hover],[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode])[data-state=hover]{background:var(--tui-background-accent-1-hover)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=secondary]:checked:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=destructive]:checked:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary][data-mode~=checked][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=destructive][data-mode~=checked][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary]:checked:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=destructive]:checked:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary][data-mode~=checked][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=destructive][data-mode~=checked][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode])[tuiWrapper][data-state=hover]{background:var(--tui-background-accent-1-hover)}}[tuiAppearance][data-appearance=secondary]:checked:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive]:checked:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][data-mode~=checked]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][data-mode~=checked]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){background:var(--tui-background-accent-1-pressed)}[tuiAppearance][data-appearance=secondary]:checked:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive]:checked:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][data-mode~=checked]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][data-mode~=checked]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){background:var(--tui-background-accent-1-pressed)}[tuiAppearance][data-appearance=secondary]:checked:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=destructive]:checked:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=secondary][data-mode~=checked][data-state=active],[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked][data-state=active],[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked][data-state=active],[tuiAppearance][data-appearance=destructive][data-mode~=checked][data-state=active],[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode])[data-state=active]{background:var(--tui-background-accent-1-pressed)}[tuiAppearance][data-appearance=secondary]:checked:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=destructive]:checked:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary][data-mode~=checked][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=destructive][data-mode~=checked][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary]:checked:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=destructive]:checked:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary][data-mode~=checked][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=destructive][data-mode~=checked][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary]:checked:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=destructive]:checked:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary][data-mode~=checked][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=destructive][data-mode~=checked][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode])[tuiWrapper][data-state=active]:hover{background:var(--tui-background-accent-1-pressed)}[tuiAppearance][data-appearance=secondary]:checked:not([data-mode]):invalid:not([data-mode]),[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode]):invalid:not([data-mode]),[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode]):invalid:not([data-mode]),[tuiAppearance][data-appearance=destructive]:checked:not([data-mode]):invalid:not([data-mode]),[tuiAppearance][data-appearance=secondary][data-mode~=checked]:invalid:not([data-mode]),[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked]:invalid:not([data-mode]),[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked]:invalid:not([data-mode]),[tuiAppearance][data-appearance=destructive][data-mode~=checked]:invalid:not([data-mode]),[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode]),[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode]),[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode]),[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode]),[tuiAppearance][data-appearance=secondary]:checked:not([data-mode])[data-mode~=invalid],[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode])[data-mode~=invalid],[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode])[data-mode~=invalid],[tuiAppearance][data-appearance=destructive]:checked:not([data-mode])[data-mode~=invalid],[tuiAppearance][data-appearance=secondary][data-mode~=checked][data-mode~=invalid],[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked][data-mode~=invalid],[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked][data-mode~=invalid],[tuiAppearance][data-appearance=destructive][data-mode~=checked][data-mode~=invalid],[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid],[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid],[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid],[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid]{background:var(--tui-status-negative);color:#fff}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=secondary]:checked:not([data-mode]):invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode]):invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode]):invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive]:checked:not([data-mode]):invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][data-mode~=checked]:invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked]:invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked]:invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][data-mode~=checked]:invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary]:checked:not([data-mode])[data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode])[data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode])[data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive]:checked:not([data-mode])[data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][data-mode~=checked][data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked][data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked][data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][data-mode~=checked][data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){background:var(--tui-status-negative);color:#fff}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=secondary]:checked:not([data-mode]):invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode]):invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode]):invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive]:checked:not([data-mode]):invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][data-mode~=checked]:invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked]:invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked]:invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][data-mode~=checked]:invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary]:checked:not([data-mode])[data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode])[data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode])[data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive]:checked:not([data-mode])[data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][data-mode~=checked][data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked][data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked][data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][data-mode~=checked][data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){background:var(--tui-status-negative);color:#fff}}[tuiAppearance][data-appearance=secondary]:checked:not([data-mode]):invalid:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode]):invalid:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode]):invalid:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=destructive]:checked:not([data-mode]):invalid:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=secondary][data-mode~=checked]:invalid:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked]:invalid:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked]:invalid:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=destructive][data-mode~=checked]:invalid:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=secondary]:checked:not([data-mode])[data-mode~=invalid][data-state=hover],[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode])[data-mode~=invalid][data-state=hover],[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode])[data-mode~=invalid][data-state=hover],[tuiAppearance][data-appearance=destructive]:checked:not([data-mode])[data-mode~=invalid][data-state=hover],[tuiAppearance][data-appearance=secondary][data-mode~=checked][data-mode~=invalid][data-state=hover],[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked][data-mode~=invalid][data-state=hover],[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked][data-mode~=invalid][data-state=hover],[tuiAppearance][data-appearance=destructive][data-mode~=checked][data-mode~=invalid][data-state=hover],[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][data-state=hover],[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][data-state=hover],[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][data-state=hover],[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][data-state=hover]{background:var(--tui-status-negative);color:#fff}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=secondary]:checked:not([data-mode]):invalid:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode]):invalid:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode]):invalid:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=destructive]:checked:not([data-mode]):invalid:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary][data-mode~=checked]:invalid:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked]:invalid:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked]:invalid:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=destructive][data-mode~=checked]:invalid:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary]:checked:not([data-mode])[data-mode~=invalid][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode])[data-mode~=invalid][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode])[data-mode~=invalid][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=destructive]:checked:not([data-mode])[data-mode~=invalid][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary][data-mode~=checked][data-mode~=invalid][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked][data-mode~=invalid][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked][data-mode~=invalid][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=destructive][data-mode~=checked][data-mode~=invalid][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary]:checked:not([data-mode]):invalid:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode]):invalid:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode]):invalid:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=destructive]:checked:not([data-mode]):invalid:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary][data-mode~=checked]:invalid:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked]:invalid:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked]:invalid:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=destructive][data-mode~=checked]:invalid:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary]:checked:not([data-mode])[data-mode~=invalid][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode])[data-mode~=invalid][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode])[data-mode~=invalid][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=destructive]:checked:not([data-mode])[data-mode~=invalid][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary][data-mode~=checked][data-mode~=invalid][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked][data-mode~=invalid][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked][data-mode~=invalid][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=destructive][data-mode~=checked][data-mode~=invalid][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][tuiWrapper][data-state=hover]{background:var(--tui-status-negative);color:#fff}}[tuiAppearance][data-appearance=secondary]:checked:not([data-mode]):invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode]):invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode]):invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive]:checked:not([data-mode]):invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][data-mode~=checked]:invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked]:invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked]:invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][data-mode~=checked]:invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary]:checked:not([data-mode])[data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode])[data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode])[data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive]:checked:not([data-mode])[data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][data-mode~=checked][data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked][data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked][data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][data-mode~=checked][data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){background:var(--tui-status-negative);color:#fff}[tuiAppearance][data-appearance=secondary]:checked:not([data-mode]):invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode]):invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode]):invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive]:checked:not([data-mode]):invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][data-mode~=checked]:invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked]:invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked]:invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][data-mode~=checked]:invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary]:checked:not([data-mode])[data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode])[data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode])[data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive]:checked:not([data-mode])[data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][data-mode~=checked][data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked][data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked][data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][data-mode~=checked][data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){background:var(--tui-status-negative);color:#fff}[tuiAppearance][data-appearance=secondary]:checked:not([data-mode]):invalid:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode]):invalid:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode]):invalid:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=destructive]:checked:not([data-mode]):invalid:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=secondary][data-mode~=checked]:invalid:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked]:invalid:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked]:invalid:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=destructive][data-mode~=checked]:invalid:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=secondary]:checked:not([data-mode])[data-mode~=invalid][data-state=active],[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode])[data-mode~=invalid][data-state=active],[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode])[data-mode~=invalid][data-state=active],[tuiAppearance][data-appearance=destructive]:checked:not([data-mode])[data-mode~=invalid][data-state=active],[tuiAppearance][data-appearance=secondary][data-mode~=checked][data-mode~=invalid][data-state=active],[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked][data-mode~=invalid][data-state=active],[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked][data-mode~=invalid][data-state=active],[tuiAppearance][data-appearance=destructive][data-mode~=checked][data-mode~=invalid][data-state=active],[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][data-state=active],[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][data-state=active],[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][data-state=active],[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][data-state=active]{background:var(--tui-status-negative);color:#fff}[tuiAppearance][data-appearance=secondary]:checked:not([data-mode]):invalid:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode]):invalid:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode]):invalid:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=destructive]:checked:not([data-mode]):invalid:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary][data-mode~=checked]:invalid:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked]:invalid:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked]:invalid:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=destructive][data-mode~=checked]:invalid:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary]:checked:not([data-mode])[data-mode~=invalid][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode])[data-mode~=invalid][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode])[data-mode~=invalid][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=destructive]:checked:not([data-mode])[data-mode~=invalid][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary][data-mode~=checked][data-mode~=invalid][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked][data-mode~=invalid][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked][data-mode~=invalid][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=destructive][data-mode~=checked][data-mode~=invalid][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary]:checked:not([data-mode]):invalid:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode]):invalid:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode]):invalid:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=destructive]:checked:not([data-mode]):invalid:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary][data-mode~=checked]:invalid:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked]:invalid:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked]:invalid:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=destructive][data-mode~=checked]:invalid:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary]:checked:not([data-mode])[data-mode~=invalid][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode])[data-mode~=invalid][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode])[data-mode~=invalid][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=destructive]:checked:not([data-mode])[data-mode~=invalid][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary][data-mode~=checked][data-mode~=invalid][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked][data-mode~=invalid][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked][data-mode~=invalid][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=destructive][data-mode~=checked][data-mode~=invalid][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary]:checked:not([data-mode]):invalid:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode]):invalid:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode]):invalid:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=destructive]:checked:not([data-mode]):invalid:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary][data-mode~=checked]:invalid:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked]:invalid:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked]:invalid:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=destructive][data-mode~=checked]:invalid:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode]):invalid:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary]:checked:not([data-mode])[data-mode~=invalid][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary-destructive]:checked:not([data-mode])[data-mode~=invalid][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary-grayscale]:checked:not([data-mode])[data-mode~=invalid][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=destructive]:checked:not([data-mode])[data-mode~=invalid][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary][data-mode~=checked][data-mode~=invalid][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary-destructive][data-mode~=checked][data-mode~=invalid][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=checked][data-mode~=invalid][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=destructive][data-mode~=checked][data-mode~=invalid][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary-destructive][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary-grayscale][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=destructive][type=checkbox]:indeterminate:not([data-mode])[data-mode~=invalid][tuiWrapper][data-state=active]:hover{background:var(--tui-status-negative);color:#fff}[tuiAppearance][data-appearance=secondary]:invalid:not([data-mode]),[tuiAppearance][data-appearance=secondary-destructive]:invalid:not([data-mode]),[tuiAppearance][data-appearance=secondary-grayscale]:invalid:not([data-mode]),[tuiAppearance][data-appearance=destructive]:invalid:not([data-mode]),[tuiAppearance][data-appearance=secondary][data-mode~=invalid],[tuiAppearance][data-appearance=secondary-destructive][data-mode~=invalid],[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=invalid],[tuiAppearance][data-appearance=destructive][data-mode~=invalid]{color:var(--tui-text-negative);background:var(--tui-status-negative-pale)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=secondary]:invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive]:invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale]:invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive]:invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){color:var(--tui-text-negative-hover);background:var(--tui-status-negative-pale-hover)}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=secondary]:invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive]:invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale]:invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive]:invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){color:var(--tui-text-negative-hover);background:var(--tui-status-negative-pale-hover)}}[tuiAppearance][data-appearance=secondary]:invalid:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=secondary-destructive]:invalid:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=secondary-grayscale]:invalid:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=destructive]:invalid:not([data-mode])[data-state=hover],[tuiAppearance][data-appearance=secondary][data-mode~=invalid][data-state=hover],[tuiAppearance][data-appearance=secondary-destructive][data-mode~=invalid][data-state=hover],[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=invalid][data-state=hover],[tuiAppearance][data-appearance=destructive][data-mode~=invalid][data-state=hover]{color:var(--tui-text-negative-hover);background:var(--tui-status-negative-pale-hover)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=secondary]:invalid:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary-destructive]:invalid:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary-grayscale]:invalid:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=destructive]:invalid:not([data-mode])[tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary][data-mode~=invalid][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary-destructive][data-mode~=invalid][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=invalid][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=destructive][data-mode~=invalid][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=secondary]:invalid:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary-destructive]:invalid:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary-grayscale]:invalid:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=destructive]:invalid:not([data-mode])[tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary][data-mode~=invalid][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary-destructive][data-mode~=invalid][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=invalid][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=destructive][data-mode~=invalid][tuiWrapper][data-state=hover]{color:var(--tui-text-negative-hover);background:var(--tui-status-negative-pale-hover)}}[tuiAppearance][data-appearance=secondary]:invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive]:invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale]:invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive]:invalid:not([data-mode]):matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){color:var(--tui-text-negative-hover);background:var(--tui-status-negative-pale-hover)}[tuiAppearance][data-appearance=secondary]:invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive]:invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale]:invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive]:invalid:not([data-mode]):is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary][data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-destructive][data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=destructive][data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){color:var(--tui-text-negative-hover);background:var(--tui-status-negative-pale-hover)}[tuiAppearance][data-appearance=secondary]:invalid:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=secondary-destructive]:invalid:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=secondary-grayscale]:invalid:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=destructive]:invalid:not([data-mode])[data-state=active],[tuiAppearance][data-appearance=secondary][data-mode~=invalid][data-state=active],[tuiAppearance][data-appearance=secondary-destructive][data-mode~=invalid][data-state=active],[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=invalid][data-state=active],[tuiAppearance][data-appearance=destructive][data-mode~=invalid][data-state=active]{color:var(--tui-text-negative-hover);background:var(--tui-status-negative-pale-hover)}[tuiAppearance][data-appearance=secondary]:invalid:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary-destructive]:invalid:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary-grayscale]:invalid:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=destructive]:invalid:not([data-mode])[tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary][data-mode~=invalid][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary-destructive][data-mode~=invalid][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=invalid][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=destructive][data-mode~=invalid][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=secondary]:invalid:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary-destructive]:invalid:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary-grayscale]:invalid:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=destructive]:invalid:not([data-mode])[tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary][data-mode~=invalid][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary-destructive][data-mode~=invalid][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=invalid][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=destructive][data-mode~=invalid][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=secondary]:invalid:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary-destructive]:invalid:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary-grayscale]:invalid:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=destructive]:invalid:not([data-mode])[tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary][data-mode~=invalid][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary-destructive][data-mode~=invalid][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=secondary-grayscale][data-mode~=invalid][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=destructive][data-mode~=invalid][tuiWrapper][data-state=active]:hover{color:var(--tui-text-negative-hover);background:var(--tui-status-negative-pale-hover)}[tuiAppearance][data-appearance=secondary-destructive],[tuiAppearance][data-appearance=destructive]{color:var(--tui-text-negative)}[tuiAppearance][data-appearance=secondary-grayscale]{color:var(--tui-text-primary)}input[type=checkbox][data-appearance=secondary],input[type=radio][data-appearance=secondary]{--tui-background-neutral-1: var(--tui-background-neutral-2);--tui-background-neutral-1-hover: var(--tui-background-neutral-2-hover);--tui-background-neutral-1-pressed: var(--tui-background-neutral-2-pressed)}[tuiAppearance][data-appearance=error],[tuiAppearance][data-appearance=success],[tuiAppearance][data-appearance=negative],[tuiAppearance][data-appearance=positive],[tuiAppearance][data-appearance=warning],[tuiAppearance][data-appearance=info],[tuiAppearance][data-appearance=neutral]{background:var(--t-bg);color:var(--tui-text-primary)}[tuiAppearance][data-appearance=error]:checked:not([data-mode]),[tuiAppearance][data-appearance=success]:checked:not([data-mode]),[tuiAppearance][data-appearance=negative]:checked:not([data-mode]),[tuiAppearance][data-appearance=positive]:checked:not([data-mode]),[tuiAppearance][data-appearance=warning]:checked:not([data-mode]),[tuiAppearance][data-appearance=info]:checked:not([data-mode]),[tuiAppearance][data-appearance=neutral]:checked:not([data-mode]),[tuiAppearance][data-appearance=error][data-mode~=checked],[tuiAppearance][data-appearance=success][data-mode~=checked],[tuiAppearance][data-appearance=negative][data-mode~=checked],[tuiAppearance][data-appearance=positive][data-mode~=checked],[tuiAppearance][data-appearance=warning][data-mode~=checked],[tuiAppearance][data-appearance=info][data-mode~=checked],[tuiAppearance][data-appearance=neutral][data-mode~=checked]{color:#fff}[tuiAppearance][data-appearance=error],[tuiAppearance][data-appearance=negative]{--t-bg: var(--tui-status-negative-pale)}[tuiAppearance][data-appearance=error]:before,[tuiAppearance][data-appearance=negative]:before,[tuiAppearance][data-appearance=error]:after,[tuiAppearance][data-appearance=negative]:after{color:var(--tui-status-negative)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=error]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=negative]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){--t-bg: var(--tui-status-negative-pale-hover)}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=error]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=negative]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){--t-bg: var(--tui-status-negative-pale-hover)}}[tuiAppearance][data-appearance=error][data-state=hover],[tuiAppearance][data-appearance=negative][data-state=hover]{--t-bg: var(--tui-status-negative-pale-hover)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=error][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=negative][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=error][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=negative][tuiWrapper][data-state=hover]{--t-bg: var(--tui-status-negative-pale-hover)}}[tuiAppearance][data-appearance=error]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=negative]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){--t-bg: var(--tui-status-negative-pale-hover)}[tuiAppearance][data-appearance=error]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=negative]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){--t-bg: var(--tui-status-negative-pale-hover)}[tuiAppearance][data-appearance=error][data-state=active],[tuiAppearance][data-appearance=negative][data-state=active]{--t-bg: var(--tui-status-negative-pale-hover)}[tuiAppearance][data-appearance=error][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=negative][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=error][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=negative][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=error][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=negative][tuiWrapper][data-state=active]:hover{--t-bg: var(--tui-status-negative-pale-hover)}[tuiAppearance][data-appearance=error]:checked:not([data-mode]),[tuiAppearance][data-appearance=negative]:checked:not([data-mode]),[tuiAppearance][data-appearance=error][data-mode~=checked],[tuiAppearance][data-appearance=negative][data-mode~=checked]{background:var(--tui-status-negative)}[tuiAppearance][data-appearance=success],[tuiAppearance][data-appearance=positive]{--t-bg: var(--tui-status-positive-pale)}[tuiAppearance][data-appearance=success]:before,[tuiAppearance][data-appearance=positive]:before,[tuiAppearance][data-appearance=success]:after,[tuiAppearance][data-appearance=positive]:after{color:var(--tui-status-positive)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=success]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=positive]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){--t-bg: var(--tui-status-positive-pale-hover)}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=success]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=positive]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){--t-bg: var(--tui-status-positive-pale-hover)}}[tuiAppearance][data-appearance=success][data-state=hover],[tuiAppearance][data-appearance=positive][data-state=hover]{--t-bg: var(--tui-status-positive-pale-hover)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=success][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=positive][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=success][tuiWrapper][data-state=hover],[tuiAppearance][data-appearance=positive][tuiWrapper][data-state=hover]{--t-bg: var(--tui-status-positive-pale-hover)}}[tuiAppearance][data-appearance=success]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=positive]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){--t-bg: var(--tui-status-positive-pale-hover)}[tuiAppearance][data-appearance=success]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]),[tuiAppearance][data-appearance=positive]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){--t-bg: var(--tui-status-positive-pale-hover)}[tuiAppearance][data-appearance=success][data-state=active],[tuiAppearance][data-appearance=positive][data-state=active]{--t-bg: var(--tui-status-positive-pale-hover)}[tuiAppearance][data-appearance=success][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=positive][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=success][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=positive][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=success][tuiWrapper][data-state=active]:hover,[tuiAppearance][data-appearance=positive][tuiWrapper][data-state=active]:hover{--t-bg: var(--tui-status-positive-pale-hover)}[tuiAppearance][data-appearance=success]:checked:not([data-mode]),[tuiAppearance][data-appearance=positive]:checked:not([data-mode]),[tuiAppearance][data-appearance=success][data-mode~=checked],[tuiAppearance][data-appearance=positive][data-mode~=checked]{background:var(--tui-status-positive)}[tuiAppearance][data-appearance=warning]{--t-bg: var(--tui-status-warning-pale)}[tuiAppearance][data-appearance=warning]:before,[tuiAppearance][data-appearance=warning]:after{color:var(--tui-status-warning)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=warning]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){--t-bg: var(--tui-status-warning-pale-hover)}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=warning]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){--t-bg: var(--tui-status-warning-pale-hover)}}[tuiAppearance][data-appearance=warning][data-state=hover]{--t-bg: var(--tui-status-warning-pale-hover)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=warning][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=warning][tuiWrapper][data-state=hover]{--t-bg: var(--tui-status-warning-pale-hover)}}[tuiAppearance][data-appearance=warning]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){--t-bg: var(--tui-status-warning-pale-hover)}[tuiAppearance][data-appearance=warning]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){--t-bg: var(--tui-status-warning-pale-hover)}[tuiAppearance][data-appearance=warning][data-state=active]{--t-bg: var(--tui-status-warning-pale-hover)}[tuiAppearance][data-appearance=warning][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=warning][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=warning][tuiWrapper][data-state=active]:hover{--t-bg: var(--tui-status-warning-pale-hover)}[tuiAppearance][data-appearance=warning]:checked:not([data-mode]),[tuiAppearance][data-appearance=warning][data-mode~=checked]{background:var(--tui-status-warning)}[tuiAppearance][data-appearance=info]{--t-bg: var(--tui-status-info-pale)}[tuiAppearance][data-appearance=info]:before,[tuiAppearance][data-appearance=info]:after{color:var(--tui-status-info)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=info]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){--t-bg: var(--tui-status-info-pale-hover)}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=info]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){--t-bg: var(--tui-status-info-pale-hover)}}[tuiAppearance][data-appearance=info][data-state=hover]{--t-bg: var(--tui-status-info-pale-hover)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=info][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=info][tuiWrapper][data-state=hover]{--t-bg: var(--tui-status-info-pale-hover)}}[tuiAppearance][data-appearance=info]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){--t-bg: var(--tui-status-info-pale-hover)}[tuiAppearance][data-appearance=info]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){--t-bg: var(--tui-status-info-pale-hover)}[tuiAppearance][data-appearance=info][data-state=active]{--t-bg: var(--tui-status-info-pale-hover)}[tuiAppearance][data-appearance=info][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=info][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=info][tuiWrapper][data-state=active]:hover{--t-bg: var(--tui-status-info-pale-hover)}[tuiAppearance][data-appearance=info]:checked:not([data-mode]),[tuiAppearance][data-appearance=info][data-mode~=checked]{background:var(--tui-status-info)}[tuiAppearance][data-appearance=neutral]{--t-bg: var(--tui-background-neutral-1)}[tuiAppearance][data-appearance=neutral]:before,[tuiAppearance][data-appearance=neutral]:after{color:var(--tui-status-neutral)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=neutral]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){--t-bg: var(--tui-background-neutral-1-hover)}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=neutral]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){--t-bg: var(--tui-background-neutral-1-hover)}}[tuiAppearance][data-appearance=neutral][data-state=hover]{--t-bg: var(--tui-background-neutral-1-hover)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=neutral][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=neutral][tuiWrapper][data-state=hover]{--t-bg: var(--tui-background-neutral-1-hover)}}[tuiAppearance][data-appearance=neutral]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){--t-bg: var(--tui-background-neutral-1-pressed)}[tuiAppearance][data-appearance=neutral]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]){--t-bg: var(--tui-background-neutral-1-pressed)}[tuiAppearance][data-appearance=neutral][data-state=active]{--t-bg: var(--tui-background-neutral-1-pressed)}[tuiAppearance][data-appearance=neutral][tuiWrapper]:active:not(._no-active),[tuiAppearance][data-appearance=neutral][tuiWrapper][data-state=active],[tuiAppearance][data-appearance=neutral][tuiWrapper][data-state=active]:hover{--t-bg: var(--tui-background-neutral-1-pressed)}[tuiAppearance][data-appearance=neutral]:checked:not([data-mode]),[tuiAppearance][data-appearance=neutral][data-mode~=checked]{background:var(--tui-status-neutral)}[tuiAppearance][data-appearance=table]:not([tuiWrapper]){content:"";position:fixed;inset:-1px;inline-size:auto;block-size:auto;border-radius:0;background:transparent;border:none;outline:none;border-bottom:calc(var(--t-row-height) - var(--t-height)) solid transparent}[tuiAppearance][data-appearance=table]:not([tuiWrapper]):not(._empty){color:var(--tui-text-primary)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=table]:not([tuiWrapper]):matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state])[data-focus=false]{background-color:var(--tui-background-neutral-1)}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=table]:not([tuiWrapper]):is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state])[data-focus=false]{background-color:var(--tui-background-neutral-1)}}[tuiAppearance][data-appearance=table]:not([tuiWrapper])[data-state=hover][data-focus=false]{background-color:var(--tui-background-neutral-1)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=table]:not([tuiWrapper])[tuiWrapper]:hover:not(._no-hover)[data-focus=false],[tuiAppearance][data-appearance=table]:not([tuiWrapper])[tuiWrapper][data-state=hover][data-focus=false]{background-color:var(--tui-background-neutral-1)}}[tuiAppearance][data-appearance=table]:not([tuiWrapper]):focus-visible:not([data-focus=false]){outline-offset:-.125rem;outline:.125rem solid var(--tui-border-focus)}[tuiAppearance][data-appearance=table]:not([tuiWrapper])[data-focus=true]{outline-offset:-.125rem;outline:.125rem solid var(--tui-border-focus)}[tuiAppearance][data-appearance=table]:not([tuiWrapper])[tuiWrapper]:not(._focused):has(:focus-visible),[tuiAppearance][data-appearance=table]:not([tuiWrapper])[tuiWrapper]._focused{outline-offset:-.125rem;outline:.125rem solid var(--tui-border-focus)}[tuiAppearance][data-appearance=table]:not([tuiWrapper]):invalid,[tuiAppearance][data-appearance=table]:not([tuiWrapper])[data-mode~=invalid]{background-origin:border-box;background-position:top right;background-repeat:no-repeat;background-image:linear-gradient(to top right,transparent 0% 50%,var(--tui-status-negative) 50% 100%);background-size:.5rem .5rem}[tuiAppearance][data-appearance=table]:not([tuiWrapper]):invalid[data-focus=false],[tuiAppearance][data-appearance=table]:not([tuiWrapper])[data-mode~=invalid][data-focus=false]{background-color:var(--tui-status-negative-pale)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=table]:not([tuiWrapper]):invalid:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state])[data-focus=false],[tuiAppearance][data-appearance=table]:not([tuiWrapper])[data-mode~=invalid]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state])[data-focus=false]{background-color:var(--tui-status-negative-pale-hover)}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=table]:not([tuiWrapper]):invalid:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state])[data-focus=false],[tuiAppearance][data-appearance=table]:not([tuiWrapper])[data-mode~=invalid]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state])[data-focus=false]{background-color:var(--tui-status-negative-pale-hover)}}[tuiAppearance][data-appearance=table]:not([tuiWrapper]):invalid[data-state=hover][data-focus=false],[tuiAppearance][data-appearance=table]:not([tuiWrapper])[data-mode~=invalid][data-state=hover][data-focus=false]{background-color:var(--tui-status-negative-pale-hover)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=table]:not([tuiWrapper]):invalid[tuiWrapper]:hover:not(._no-hover)[data-focus=false],[tuiAppearance][data-appearance=table]:not([tuiWrapper])[data-mode~=invalid][tuiWrapper]:hover:not(._no-hover)[data-focus=false],[tuiAppearance][data-appearance=table]:not([tuiWrapper]):invalid[tuiWrapper][data-state=hover][data-focus=false],[tuiAppearance][data-appearance=table]:not([tuiWrapper])[data-mode~=invalid][tuiWrapper][data-state=hover][data-focus=false]{background-color:var(--tui-status-negative-pale-hover)}}[tuiAppearance][data-appearance=table]:not([tuiWrapper]):invalid:disabled:not([data-state]),[tuiAppearance][data-appearance=table]:not([tuiWrapper])[data-mode~=invalid]:disabled:not([data-state]),[tuiAppearance][data-appearance=table]:not([tuiWrapper]):invalid[data-state=disabled],[tuiAppearance][data-appearance=table]:not([tuiWrapper])[data-mode~=invalid][data-state=disabled]{background:transparent;outline:none}[tuiAppearance][data-appearance=table]:not([tuiWrapper]):invalid[tuiWrapper]:disabled:not([data-state]),[tuiAppearance][data-appearance=table]:not([tuiWrapper])[data-mode~=invalid][tuiWrapper]:disabled:not([data-state]),[tuiAppearance][data-appearance=table]:not([tuiWrapper]):invalid[tuiWrapper][data-state=disabled],[tuiAppearance][data-appearance=table]:not([tuiWrapper])[data-mode~=invalid][tuiWrapper][data-state=disabled]{background:transparent;outline:none}[tuiAppearance][data-appearance=table]:not([tuiWrapper]):invalid:focus-visible:not([data-focus=false]),[tuiAppearance][data-appearance=table]:not([tuiWrapper])[data-mode~=invalid]:focus-visible:not([data-focus=false]){background-color:transparent;outline-offset:-.0625rem;outline:.0625rem solid var(--tui-status-negative)}[tuiAppearance][data-appearance=table]:not([tuiWrapper]):invalid[data-focus=true],[tuiAppearance][data-appearance=table]:not([tuiWrapper])[data-mode~=invalid][data-focus=true]{background-color:transparent;outline-offset:-.0625rem;outline:.0625rem solid var(--tui-status-negative)}[tuiAppearance][data-appearance=table]:not([tuiWrapper]):invalid[tuiWrapper]:not(._focused):has(:focus-visible),[tuiAppearance][data-appearance=table]:not([tuiWrapper])[data-mode~=invalid][tuiWrapper]:not(._focused):has(:focus-visible),[tuiAppearance][data-appearance=table]:not([tuiWrapper]):invalid[tuiWrapper]._focused,[tuiAppearance][data-appearance=table]:not([tuiWrapper])[data-mode~=invalid][tuiWrapper]._focused{background-color:transparent;outline-offset:-.0625rem;outline:.0625rem solid var(--tui-status-negative)}[tuiWrapper]{transition-property:color,background,opacity;transition-duration:var(--tui-duration, .3s);transition-timing-function:ease-in-out;position:relative;display:block;block-size:100%;inline-size:100%;appearance:none;border-radius:inherit}[tuiWrapper]:disabled:disabled,[tuiWrapper][data-state=disabled][data-state=disabled]{pointer-events:none;opacity:var(--tui-disabled-opacity)}[tuiWrapper][data-appearance=textfield]{transition-property:box-shadow,background;transition-duration:var(--tui-duration, .3s);transition-timing-function:ease-in-out;background:var(--tui-background-base);color:var(--tui-text-primary);outline:none!important;box-shadow:0 .125rem .1875rem #0000001a}[tuiWrapper][data-appearance=textfield]:after{transition-property:color;transition-duration:var(--tui-duration, .3s);transition-timing-function:ease-in-out;position:absolute;inset:0;content:"";border-radius:inherit;border:1px solid currentColor;pointer-events:none;color:var(--tui-border-normal)}@media (hover: hover) and (pointer: fine){[tuiWrapper][data-appearance=textfield]:hover:not(._no-hover),[tuiWrapper][data-appearance=textfield][data-state=hover]{box-shadow:0 .125rem .3125rem #00000029}}[tuiWrapper][data-appearance=textfield]:focus-visible:focus-visible{box-shadow:none}[tuiWrapper][data-appearance=textfield]:focus-visible:focus-visible:after{border-width:2px;color:var(--tui-background-accent-1)}[tuiWrapper][data-appearance=textfield]:has(:focus-visible){box-shadow:none}[tuiWrapper][data-appearance=textfield]:has(:focus-visible):after{border-width:2px;color:var(--tui-background-accent-1)}[tuiWrapper][data-appearance=textfield]._focused._focused{box-shadow:none}[tuiWrapper][data-appearance=textfield]._focused._focused:after{border-width:2px;color:var(--tui-background-accent-1)}[tuiWrapper][data-appearance=textfield][data-state=readonly][data-state=readonly]{box-shadow:none;background:transparent}[tuiWrapper][data-appearance=textfield][data-state=readonly][data-state=readonly]:after{color:var(--tui-border-normal)}[tuiWrapper][data-appearance=textfield]:disabled:disabled,[tuiWrapper][data-appearance=textfield][data-state=disabled][data-state=disabled]{box-shadow:none}[tuiWrapper][data-appearance=textfield]:invalid:invalid:after,[tuiWrapper][data-appearance=textfield]._invalid._invalid:after{color:var(--tui-text-negative)}[tuiTheme=dark][tuiWrapper][data-appearance=textfield],[tuiTheme=dark] [tuiWrapper][data-appearance=textfield]{background:var(--tui-background-neutral-1)}@media (hover: hover) and (pointer: fine){[tuiTheme=dark][tuiWrapper][data-appearance=textfield]:hover:not(._no-hover),[tuiTheme=dark] [tuiWrapper][data-appearance=textfield]:hover:not(._no-hover),[tuiTheme=dark][tuiWrapper][data-appearance=textfield][data-state=hover],[tuiTheme=dark] [tuiWrapper][data-appearance=textfield][data-state=hover]{background:var(--tui-background-neutral-1-hover)}}[tuiTheme=dark][tuiWrapper][data-appearance=textfield]:focus-visible:focus-visible,[tuiTheme=dark] [tuiWrapper][data-appearance=textfield]:focus-visible:focus-visible{background:transparent}[tuiTheme=dark][tuiWrapper][data-appearance=textfield]:has(:focus-visible),[tuiTheme=dark] [tuiWrapper][data-appearance=textfield]:has(:focus-visible){background:transparent}[tuiTheme=dark][tuiWrapper][data-appearance=textfield]._focused._focused,[tuiTheme=dark] [tuiWrapper][data-appearance=textfield]._focused._focused{background:transparent}[tuiWrapper][data-appearance=table]{border-radius:0;background:transparent;color:var(--tui-text-primary);outline:none!important}[tuiWrapper][data-appearance=table]:before,[tuiWrapper][data-appearance=table][data-appearance=table]:after{content:"";position:fixed;top:-.03125rem;left:-1px;right:-.03125rem;bottom:-1px}[tuiWrapper][data-appearance=table]:before{transition-property:background;transition-duration:var(--tui-duration, .3s);transition-timing-function:ease-in-out;z-index:-1;background-repeat:no-repeat;background-position:top right;background-size:.5rem .5rem}[tuiWrapper][data-appearance=table][data-appearance=table]:after{border:1px solid currentColor;border-radius:inherit;pointer-events:none;color:var(--tui-border-normal)}@media (hover: hover) and (pointer: fine){[tuiWrapper][data-appearance=table]:hover:not(._no-hover):not(._focused):before,[tuiWrapper][data-appearance=table][data-state=hover]:not(._focused):before{background-color:var(--tui-background-neutral-1)}}[tuiWrapper][data-appearance=table]:focus-visible:focus-visible{background:transparent}[tuiWrapper][data-appearance=table]:focus-visible:focus-visible:after{border-width:2px;color:var(--tui-border-focus)}[tuiWrapper][data-appearance=table]:has(:focus-visible){background:transparent}[tuiWrapper][data-appearance=table]:has(:focus-visible):after{border-width:2px;color:var(--tui-border-focus)}[tuiWrapper][data-appearance=table]._focused._focused{background:transparent}[tuiWrapper][data-appearance=table]._focused._focused:after{border-width:2px;color:var(--tui-border-focus)}[tuiWrapper][data-appearance=table]:invalid:invalid:before,[tuiWrapper][data-appearance=table]._invalid._invalid:before{background-image:linear-gradient(to top right,transparent 0%,transparent 50%,var(--tui-status-negative) 50%,var(--tui-status-negative) 100%)}[tuiWrapper][data-appearance=table]:invalid:invalid:not(._focused):before,[tuiWrapper][data-appearance=table]._invalid._invalid:not(._focused):before{background-color:var(--tui-status-negative-pale)}@media (hover: hover) and (pointer: fine){[tuiWrapper][data-appearance=table]:invalid:invalid:hover:not(._no-hover):not(._focused):before,[tuiWrapper][data-appearance=table]._invalid._invalid:hover:not(._no-hover):not(._focused):before,[tuiWrapper][data-appearance=table]:invalid:invalid[data-state=hover]:not(._focused):before,[tuiWrapper][data-appearance=table]._invalid._invalid[data-state=hover]:not(._focused):before{background-color:var(--tui-status-negative-pale-hover)}}[tuiWrapper][data-appearance=table]:invalid:invalid:disabled:disabled,[tuiWrapper][data-appearance=table]._invalid._invalid:disabled:disabled,[tuiWrapper][data-appearance=table]:invalid:invalid[data-state=disabled][data-state=disabled],[tuiWrapper][data-appearance=table]._invalid._invalid[data-state=disabled][data-state=disabled]{background:transparent}[tuiWrapper][data-appearance=table]:invalid:invalid:focus-visible:focus-visible,[tuiWrapper][data-appearance=table]._invalid._invalid:focus-visible:focus-visible{background:transparent;--tui-border-focus: var(--tui-status-negative)}[tuiWrapper][data-appearance=table]:invalid:invalid:focus-visible:focus-visible:after,[tuiWrapper][data-appearance=table]._invalid._invalid:focus-visible:focus-visible:after{border-width:1px}[tuiWrapper][data-appearance=table]:invalid:invalid:has(:focus-visible),[tuiWrapper][data-appearance=table]._invalid._invalid:has(:focus-visible){background:transparent;--tui-border-focus: var(--tui-status-negative)}[tuiWrapper][data-appearance=table]:invalid:invalid:has(:focus-visible):after,[tuiWrapper][data-appearance=table]._invalid._invalid:has(:focus-visible):after{border-width:1px}[tuiWrapper][data-appearance=table]:invalid:invalid._focused._focused,[tuiWrapper][data-appearance=table]._invalid._invalid._focused._focused{background:transparent;--tui-border-focus: var(--tui-status-negative)}[tuiWrapper][data-appearance=table]:invalid:invalid._focused._focused:after,[tuiWrapper][data-appearance=table]._invalid._invalid._focused._focused:after{border-width:1px}table [tuiWrapper][data-appearance=table][data-appearance=table]:not(._focused):after{border-width:0}table [tuiWrapper][data-appearance=table]._focused{z-index:1}[tuiWrapper][data-appearance=icon]{color:var(--tui-text-tertiary)}[tuiWrapper]:not([data-state=readonly]):hover .t-textfield-icon [tuiWrapper][data-appearance=icon]:not([data-state=disabled]){color:var(--tui-text-secondary)}@media (hover: hover) and (pointer: fine){[tuiWrapper][data-appearance=icon]:hover:not(._no-hover),[tuiWrapper][data-appearance=icon][data-state=hover]{color:var(--tui-text-secondary)}}[tuiWrapper][data-appearance=icon]:active:not(._no-active),[tuiWrapper][data-appearance=icon][data-state=active],[tuiWrapper][data-appearance=icon][data-state=active]:hover{color:var(--tui-text-primary)}tui-primitive-textfield:hover:not(._disabled) [tuiAppearance][data-appearance=icon],tui-textarea:hover:not(._disabled) [tuiAppearance][data-appearance=icon],tui-input-tag:hover:not(._disabled) [tuiAppearance][data-appearance=icon]{color:var(--tui-text-secondary)}tui-primitive-textfield:hover:not(._disabled) [tuiAppearance][data-appearance=icon]:active:not(._no-active),tui-textarea:hover:not(._disabled) [tuiAppearance][data-appearance=icon]:active:not(._no-active),tui-input-tag:hover:not(._disabled) [tuiAppearance][data-appearance=icon]:active:not(._no-active),tui-primitive-textfield:hover:not(._disabled) [tuiAppearance][data-appearance=icon][data-state=active],tui-textarea:hover:not(._disabled) [tuiAppearance][data-appearance=icon][data-state=active],tui-input-tag:hover:not(._disabled) [tuiAppearance][data-appearance=icon][data-state=active],tui-primitive-textfield:hover:not(._disabled) [tuiAppearance][data-appearance=icon][data-state=active]:hover,tui-textarea:hover:not(._disabled) [tuiAppearance][data-appearance=icon][data-state=active]:hover,tui-input-tag:hover:not(._disabled) [tuiAppearance][data-appearance=icon][data-state=active]:hover{color:var(--tui-text-primary)}[tuiWrapper][data-appearance=none]{outline:none}[tuiWrapper][data-appearance=none]:after{border:none}[tuiAppearance][data-appearance=textfield]{transition-property:box-shadow,background-color,outline-color,border-color;transition-duration:var(--tui-duration, .3s);transition-timing-function:ease-in-out;--t-shadow: 0 .125rem .1875rem rgba(0, 0, 0, .1);background-color:var(--tui-background-base);color:var(--tui-text-primary);box-shadow:var(--t-shadow);outline:1px solid var(--tui-border-normal);outline-offset:-1px;border-width:0}[tuiAppearance][data-appearance=textfield]:not([tuiWrapper]):before,[tuiAppearance][data-appearance=textfield]:not([tuiWrapper]):after{transition-property:color,transform;transition-duration:var(--tui-duration, .3s);transition-timing-function:ease-in-out;color:var(--tui-text-tertiary)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=textfield]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){--t-shadow: 0 .125rem .3125rem rgba(0, 0, 0, .16)}[tuiAppearance][data-appearance=textfield]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]):not([tuiWrapper]):before,[tuiAppearance][data-appearance=textfield]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]):not([tuiWrapper]):after{color:var(--tui-text-secondary)}}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=textfield]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){--t-shadow: 0 .125rem .3125rem rgba(0, 0, 0, .16)}[tuiAppearance][data-appearance=textfield]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]):not([tuiWrapper]):before,[tuiAppearance][data-appearance=textfield]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]):not([tuiWrapper]):after{color:var(--tui-text-secondary)}}[tuiAppearance][data-appearance=textfield][data-state=hover]{--t-shadow: 0 .125rem .3125rem rgba(0, 0, 0, .16)}[tuiAppearance][data-appearance=textfield][data-state=hover]:not([tuiWrapper]):before,[tuiAppearance][data-appearance=textfield][data-state=hover]:not([tuiWrapper]):after{color:var(--tui-text-secondary)}@media (hover: hover) and (pointer: fine){[tuiAppearance][data-appearance=textfield][tuiWrapper]:hover:not(._no-hover),[tuiAppearance][data-appearance=textfield][tuiWrapper][data-state=hover]{--t-shadow: 0 .125rem .3125rem rgba(0, 0, 0, .16)}[tuiAppearance][data-appearance=textfield][tuiWrapper]:hover:not(._no-hover):not([tuiWrapper]):before,[tuiAppearance][data-appearance=textfield][tuiWrapper][data-state=hover]:not([tuiWrapper]):before,[tuiAppearance][data-appearance=textfield][tuiWrapper]:hover:not(._no-hover):not([tuiWrapper]):after,[tuiAppearance][data-appearance=textfield][tuiWrapper][data-state=hover]:not([tuiWrapper]):after{color:var(--tui-text-secondary)}}[tuiAppearance][data-appearance=textfield]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]):not([tuiWrapper]):before,[tuiAppearance][data-appearance=textfield]:matches(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]):not([tuiWrapper]):after{color:var(--tui-text-primary)}[tuiAppearance][data-appearance=textfield]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]):not([tuiWrapper]):before,[tuiAppearance][data-appearance=textfield]:is(a,button,select,textarea,input,label):not(:disabled):active:not(:disabled):not([data-state]):not([tuiWrapper]):after{color:var(--tui-text-primary)}[tuiAppearance][data-appearance=textfield][data-state=active]:not([tuiWrapper]):before,[tuiAppearance][data-appearance=textfield][data-state=active]:not([tuiWrapper]):after{color:var(--tui-text-primary)}[tuiAppearance][data-appearance=textfield][tuiWrapper]:active:not(._no-active):not([tuiWrapper]):before,[tuiAppearance][data-appearance=textfield][tuiWrapper][data-state=active]:not([tuiWrapper]):before,[tuiAppearance][data-appearance=textfield][tuiWrapper][data-state=active]:hover:not([tuiWrapper]):before,[tuiAppearance][data-appearance=textfield][tuiWrapper]:active:not(._no-active):not([tuiWrapper]):after,[tuiAppearance][data-appearance=textfield][tuiWrapper][data-state=active]:not([tuiWrapper]):after,[tuiAppearance][data-appearance=textfield][tuiWrapper][data-state=active]:hover:not([tuiWrapper]):after{color:var(--tui-text-primary)}[tuiAppearance][data-appearance=textfield]:focus-visible:not([data-focus=false]){box-shadow:none;outline:.125rem solid var(--tui-background-accent-1);outline-offset:-.125rem}[tuiAppearance][data-appearance=textfield][data-focus=true]{box-shadow:none;outline:.125rem solid var(--tui-background-accent-1);outline-offset:-.125rem}[tuiAppearance][data-appearance=textfield][tuiWrapper]:not(._focused):has(:focus-visible),[tuiAppearance][data-appearance=textfield][tuiWrapper]._focused{box-shadow:none;outline:.125rem solid var(--tui-background-accent-1);outline-offset:-.125rem}[tuiAppearance][data-appearance=textfield]:disabled:not([data-state]),[tuiAppearance][data-appearance=textfield][data-state=disabled]{box-shadow:none}[tuiAppearance][data-appearance=textfield][tuiWrapper]:disabled:not([data-state]),[tuiAppearance][data-appearance=textfield][tuiWrapper][data-state=disabled]{box-shadow:none}[tuiAppearance][data-appearance=textfield][data-mode~=invalid][data-mode~=invalid],[tuiAppearance][data-appearance=textfield]:invalid:not([data-mode]){outline-color:var(--tui-status-negative)}[tuiAppearance][data-appearance=textfield][data-mode~=readonly],input[tuiAppearance][data-appearance=textfield]:read-only:not([data-mode]){background:transparent!important;box-shadow:none!important;outline-color:var(--tui-border-normal)!important}[tuiAppearance][data-appearance=textfield][chrome-autofilled],[tuiAppearance][data-appearance=textfield]:-webkit-autofill{-webkit-text-fill-color:var(--tui-text-primary)!important;caret-color:var(--tui-text-primary)!important;box-shadow:0 0 0 100rem var(--tui-service-autofill-background) inset!important;transition:background-color 600000s 0s}[tuiTheme=dark] [tuiAppearance][data-appearance=textfield],[tuiTheme=dark][tuiAppearance][data-appearance=textfield]{background-color:var(--tui-background-neutral-1)}@media (hover: hover) and (pointer: fine){[tuiTheme=dark] [tuiAppearance][data-appearance=textfield]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiTheme=dark][tuiAppearance][data-appearance=textfield]:matches(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){background-color:var(--tui-background-neutral-1-hover)}}@media (hover: hover) and (pointer: fine){[tuiTheme=dark] [tuiAppearance][data-appearance=textfield]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]),[tuiTheme=dark][tuiAppearance][data-appearance=textfield]:is(a,button,select,textarea,input,label):not(:disabled):hover:not(:disabled):not([data-state]){background-color:var(--tui-background-neutral-1-hover)}}[tuiTheme=dark] [tuiAppearance][data-appearance=textfield][data-state=hover],[tuiTheme=dark][tuiAppearance][data-appearance=textfield][data-state=hover]{background-color:var(--tui-background-neutral-1-hover)}@media (hover: hover) and (pointer: fine){[tuiTheme=dark] [tuiAppearance][data-appearance=textfield][tuiWrapper]:hover:not(._no-hover),[tuiTheme=dark][tuiAppearance][data-appearance=textfield][tuiWrapper]:hover:not(._no-hover),[tuiTheme=dark] [tuiAppearance][data-appearance=textfield][tuiWrapper][data-state=hover],[tuiTheme=dark][tuiAppearance][data-appearance=textfield][tuiWrapper][data-state=hover]{background-color:var(--tui-background-neutral-1-hover)}}[tuiTheme=dark] [tuiAppearance][data-appearance=textfield]:focus-visible:not([data-focus=false]),[tuiTheme=dark][tuiAppearance][data-appearance=textfield]:focus-visible:not([data-focus=false]){background-color:transparent!important}[tuiTheme=dark] [tuiAppearance][data-appearance=textfield][data-focus=true],[tuiTheme=dark][tuiAppearance][data-appearance=textfield][data-focus=true]{background-color:transparent!important}[tuiTheme=dark] [tuiAppearance][data-appearance=textfield][tuiWrapper]:not(._focused):has(:focus-visible),[tuiTheme=dark][tuiAppearance][data-appearance=textfield][tuiWrapper]:not(._focused):has(:focus-visible),[tuiTheme=dark] [tuiAppearance][data-appearance=textfield][tuiWrapper]._focused,[tuiTheme=dark][tuiAppearance][data-appearance=textfield][tuiWrapper]._focused{background-color:transparent!important}@font-face{font-family:Akrobat;src:url(/assets/fonts/Akrobat-Light.woff2) format("woff2"),url(/assets/fonts/Akrobat-Light.woff) format("woff");font-weight:300;font-style:normal;font-display:swap}@font-face{font-family:Akrobat;src:url(/assets/fonts/Akrobat-Regular.woff2) format("woff2"),url(/assets/fonts/Akrobat-Regular.woff) format("woff");font-weight:400;font-style:normal;font-display:swap}@font-face{font-family:Akrobat;src:url(/assets/fonts/Akrobat-Bold.woff2) format("woff2"),url(/assets/fonts/Akrobat-Bold.woff) format("woff");font-weight:700;font-style:normal;font-display:swap}html{-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}:root{--grf-color-1: #ab8d4d;--grf-color-2: #d7b56d;--grf-color-3: #fbf8f0;--grf-color-4: #013b53;--grf-color-5: #006080;--grf-color-6: #e9f8fc;--grf-color-7: #1a1a1a;--grf-color-8: #9299a2;--grf-color-9: #fbfbfb;--grf-color-10: #ffffff;--tui-font-heading: "Akrobat", -apple-system, "BlinkMacSystemFont", system-ui, "Roboto", "Segoe UI", "Helvetica Neue", sans-serif;--tui-font-text: "Akrobat", -apple-system, "BlinkMacSystemFont", system-ui, "Roboto", "Segoe UI", "Helvetica Neue", sans-serif}[tuiTheme=dark]{box-sizing:border-box;--tui-text-action: var(--grf-color-2);--tui-background-base-alt: var(--grf-color-7);--tui-background-accent-1: var(--grf-color-1);--tui-background-accent-1-hover: var(--grf-color-2);--tui-background-accent-1-pressed: var(--grf-color-1);--tui-text-action: var(--grf-color-1);--tui-text-action-hover: var(--grf-color-2)}:root,[tuiTheme=light]{box-sizing:border-box;--tui-text-action: var(--grf-color-5);--tui-background-base-alt: var(--grf-color-9);--tui-background-accent-1: var(--grf-color-4);--tui-background-accent-1-hover: var(--grf-color-5);--tui-background-accent-1-pressed: var(--grf-color-4);--tui-text-action: var(--grf-color-4);--tui-text-action-hover: var(--grf-color-5);--tui-font-heading-1: bold 2.25rem/2.5rem var(--tui-font-heading);--tui-font-heading-2: bold 1.5rem/1.75rem var(--tui-font-heading);--tui-font-heading-3: bold 1.5rem/1.75rem var(--tui-font-heading);--tui-font-heading-4: bold 1.5rem/1.75rem var(--tui-font-heading);--tui-font-heading-5: bold 1.5rem/1.75rem var(--tui-font-heading);--tui-font-heading-6: bold 1.5rem/1.75rem var(--tui-font-heading);--tui-font-text-xl: normal 1.1875rem/1.75rem var(--tui-font-text);--tui-font-text-l: normal 1rem/1.5rem var(--tui-font-text);--tui-font-text-m: normal 1rem/1.5rem var(--tui-font-text);--tui-font-text-s: normal .8125rem/1.25rem var(--tui-font-text);--tui-font-text-xs: normal .6875rem/1rem var(--tui-font-text);--tui-font-text-ui-l: normal 1.0625rem/1.5rem var(--tui-font-text);--tui-font-text-ui-m: normal 1rem/1.25rem var(--tui-font-text);--tui-font-text-ui-s: normal .8125rem/1rem var(--tui-font-text);--tui-font-text-ui-xs: normal .6875rem/.8125rem var(--tui-font-text);--tui-radius-xs: .25rem;--tui-radius-s: .5rem;--tui-radius-m: .625rem;--tui-radius-l: 1.75rem;--tui-radius-xl: 1.5rem;--tui-height-xs: 1.5rem;--tui-height-s: 2rem;--tui-height-m: 2.75rem;--tui-height-l: 3.5rem;--tui-padding-s: .625rem;--tui-padding-m: .75rem;--tui-padding-l: 1rem;--tui-duration: .3s;--tui-disabled-opacity: .56}:root body,[tuiTheme=light] body{text-rendering:optimizeLegibility;font:var(--tui-font-text)}:root h1,[tuiTheme=light] h1{font:var(--tui-font-heading-1);margin:2rem 0rem 1rem}:root h2,[tuiTheme=light] h2{font:var(--tui-font-heading-2);margin:2rem 0rem 1rem}:root h3,[tuiTheme=light] h3{font:var(--tui-font-heading-3);margin:2rem 0rem 1rem}:root h4,[tuiTheme=light] h4{font:var(--tui-font-heading-4);margin:2rem 0rem 1rem}:root h5,[tuiTheme=light] h5{font:var(--tui-font-heading-5);margin:2rem 0rem 1rem}:root h6,[tuiTheme=light] h6{font:var(--tui-font-heading-6);margin:2rem 0rem 1rem}:root p,[tuiTheme=light] p{font:var(--tui-font-text-l)}:root div,[tuiTheme=light] div{font:var(--tui-font-text-l)}:root span,[tuiTheme=light] span{font:var(--tui-font-text-l)}.markup-simple-text{display:block!important}.markup-header{font-size:1.75rem!important;font-weight:600!important;display:block!important;padding-bottom:.75rem!important;padding-top:1.25rem!important}.markup-sub-header{font-size:1.25rem!important;font-weight:600!important;display:block!important;padding-bottom:.75rem!important;padding-top:1rem!important}.markup-comment,.markup-quote,.markup-attention,.markup-advantage,.markup-video,.markup-slider,.markup-stepper{display:block!important;background-color:var(--tui-status-info-pale)!important;padding:2rem!important;margin:0rem!important;border-radius:var(--tui-radius-s)!important}.markup-two-column{background-color:var(--tui-status-info-pale)!important;padding:2rem!important;margin:0rem!important;border-radius:var(--tui-radius-s)!important;display:grid;gap:2em;grid-template-columns:repeat(2,1fr);padding:1em;margin:0 auto;box-sizing:border-box;height:auto}.markup-ordered-list{display:block!important;margin:.75rem!important;list-style-type:decimal!important;box-sizing:border-box!important}.markup-ordered-list li{display:list-item!important;list-style:decimal!important;text-align:left!important;unicode-bidi:isolate!important;position:relative!important;padding-left:1rem!important;left:1rem!important;word-wrap:break-word!important;padding-bottom:.25rem!important;box-sizing:border-box!important}.markup-ordered-list li:before{content:none!important;position:absolute!important;display:block!important;background-color:var(--tui-status-positive)!important;box-sizing:border-box!important}.markup-un-ordered-list{display:block!important;margin:.75rem!important;list-style-type:none!important;box-sizing:border-box!important}.markup-un-ordered-list li{display:list-item!important;text-align:left!important;unicode-bidi:isolate!important;position:relative!important;padding-left:2rem!important;word-wrap:break-word!important;padding-bottom:.25rem!important;box-sizing:border-box!important}.markup-un-ordered-list li:before{content:""!important;position:absolute!important;display:block!important;left:0!important;top:12px!important;inline-size:5px!important;block-size:5px!important;border-radius:100%!important;background-color:var(--tui-status-positive)!important;box-sizing:border-box!important}.markup-strong{font-weight:600!important;padding:0 .25rem!important;border-radius:.25rem!important}.markup-italic{font-style:italic!important;padding:0 .25rem!important;border-radius:.25rem!important}
`;